/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token.event.convert;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBFBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBEndToken;
import org.exbin.xbup.core.parser.token.XBTAttributeToken;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTDataToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.parser.token.event.XBEventListener;
import org.exbin.xbup.core.parser.token.event.XBEventProducer;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;

@ParametersAreNonnullByDefault
public class XBTToXBEventConvertor
implements XBTEventListener,
XBEventProducer {
    @Nonnull
    private XBEventListener eventListener;

    public XBTToXBEventConvertor(XBEventListener eventListener) {
        this.eventListener = eventListener;
    }

    @Override
    public void attachXBEventListener(XBEventListener eventListener) {
        this.eventListener = eventListener;
    }

    @Override
    public void putXBTToken(XBTToken token) throws XBProcessingException, IOException {
        switch (token.getTokenType()) {
            case BEGIN: {
                this.eventListener.putXBToken(XBBeginToken.create(((XBTBeginToken)token).getTerminationMode()));
                break;
            }
            case TYPE: {
                if (((XBTTypeToken)token).getBlockType() instanceof XBFBlockType) {
                    this.eventListener.putXBToken(XBAttributeToken.create(((XBFBlockType)((XBTTypeToken)token).getBlockType()).getGroupID()));
                    this.eventListener.putXBToken(XBAttributeToken.create(((XBFBlockType)((XBTTypeToken)token).getBlockType()).getBlockID()));
                    break;
                }
                throw new XBProcessingException("Unexpected block type", XBProcessingExceptionType.BLOCK_TYPE_MISMATCH);
            }
            case ATTRIBUTE: {
                this.eventListener.putXBToken(XBAttributeToken.create(((XBTAttributeToken)token).getAttribute()));
                break;
            }
            case DATA: {
                this.eventListener.putXBToken(XBDataToken.create(((XBTDataToken)token).getData()));
                break;
            }
            case END: {
                this.eventListener.putXBToken(XBEndToken.create());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected token type " + token.getTokenType().toString());
            }
        }
    }
}

