/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token.event.convert;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBasicBlockType;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBDBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.declaration.XBContext;
import org.exbin.xbup.core.block.declaration.XBLevelContext;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTDataToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTokenType;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.parser.token.convert.XBTListenerToToken;
import org.exbin.xbup.core.parser.token.event.XBTEventFilter;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.util.StreamUtils;

@ParametersAreNonnullByDefault
public class XBTEventTypeUndeclaringFilter
implements XBTEventFilter {
    private XBTEventListener eventListener;
    private XBCatalog catalog;
    private final List<XBLevelContext> contexts = new ArrayList<XBLevelContext>();
    private XBLevelContext currentContext = null;
    private int documentDepth = 0;
    private XBBlockTerminationMode beginTerminationMode;

    public XBTEventTypeUndeclaringFilter(XBCatalog catalog) {
        this(catalog, null);
    }

    public XBTEventTypeUndeclaringFilter(XBCatalog catalog, XBTEventListener eventListener) {
        this.catalog = catalog;
        this.currentContext = new XBLevelContext(catalog, catalog.getRootContext(), 0);
        this.eventListener = eventListener;
    }

    public XBTEventTypeUndeclaringFilter(XBContext initialContext) {
        this.currentContext = new XBLevelContext(this.catalog, initialContext, 0);
    }

    public XBTEventTypeUndeclaringFilter(XBContext initialContext, XBTEventListener eventListener) {
        this(initialContext);
        this.eventListener = eventListener;
    }

    @Override
    public void putXBTToken(XBTToken token) throws XBProcessingException, IOException {
        if (this.currentContext != null && !this.currentContext.isDeclarationFinished()) {
            if (token.getTokenType() == XBTTokenType.DATA) {
                InputStream inputStream = ((XBTDataToken)token).getData();
                ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
                StreamUtils.copyInputStreamToOutputStream(inputStream, dataStream);
                this.currentContext.dataXBT(new ByteArrayInputStream(dataStream.toByteArray()));
                token = XBTDataToken.create(new ByteArrayInputStream(dataStream.toByteArray()));
            } else {
                XBTListenerToToken.tokenToListener(token, this.currentContext);
            }
        }
        switch (token.getTokenType()) {
            case BEGIN: {
                ++this.documentDepth;
                this.beginTerminationMode = ((XBTBeginToken)token).getTerminationMode();
                this.eventListener.putXBTToken(token);
                break;
            }
            case TYPE: {
                XBBlockType blockType = ((XBTTypeToken)token).getBlockType();
                if (blockType.getAsBasicType() == XBBasicBlockType.DECLARATION) {
                    ++this.documentDepth;
                    this.contexts.add(this.currentContext);
                    this.currentContext = new XBLevelContext(this.catalog, this.currentContext == null ? null : this.currentContext.getContext(), this.documentDepth);
                    this.currentContext.beginXBT(this.beginTerminationMode);
                    this.currentContext.typeXBT(blockType);
                } else if (blockType instanceof XBDBlockType) {
                    XBFixedBlockType fixedType = this.currentContext.getContext().getFixedBlockType((XBDBlockType)blockType);
                    if (fixedType == null) {
                        throw new XBProcessingException("Unable to match block type", XBProcessingExceptionType.BLOCK_TYPE_MISMATCH);
                    }
                    this.eventListener.putXBTToken(XBTTypeToken.create(fixedType));
                    return;
                }
                this.eventListener.putXBTToken(token);
                break;
            }
            case ATTRIBUTE: {
                this.eventListener.putXBTToken(token);
                break;
            }
            case DATA: {
                this.eventListener.putXBTToken(token);
                break;
            }
            case END: {
                --this.documentDepth;
                if (this.currentContext != null && this.currentContext.getDepthLevel() > this.documentDepth) {
                    this.currentContext = this.contexts.size() > 0 ? this.contexts.remove(this.contexts.size() - 1) : null;
                }
                this.eventListener.putXBTToken(token);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected token type " + token.getTokenType().toString());
            }
        }
    }

    @Override
    public void attachXBTEventListener(XBTEventListener eventListener) {
        this.eventListener = eventListener;
    }
}

