/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token.event;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.parser.XBParserMode;
import org.exbin.xbup.core.parser.XBParserState;
import org.exbin.xbup.core.parser.XBParsingException;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBHead;
import org.exbin.xbup.core.parser.basic.wrapper.FixedDataOutputStreamWrapper;
import org.exbin.xbup.core.parser.basic.wrapper.TerminatedDataOutputStreamWrapper;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBEndToken;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.parser.token.convert.XBTokenBuffer;
import org.exbin.xbup.core.parser.token.event.XBEventListener;
import org.exbin.xbup.core.stream.FinishableStream;
import org.exbin.xbup.core.ubnumber.type.UBENat32;
import org.exbin.xbup.core.ubnumber.type.UBNat32;
import org.exbin.xbup.core.util.StreamUtils;

@ParametersAreNonnullByDefault
public class XBSEventWriter
implements Closeable,
XBEventListener {
    private OutputStream stream;
    private XBParserState parserState = XBParserState.START;
    private XBParserMode parserMode = XBParserMode.FULL;
    private final XBTokenBuffer tokenBuffer = new XBTokenBuffer();
    private final List<Integer> sizeLimits = new ArrayList<Integer>();
    private int bufferedFromLevel = -1;
    private int depthLevel = 0;
    private XBBlockTerminationMode terminationMode;
    private XBBlockDataMode dataMode;
    private final List<XBAttribute> attributeList = new ArrayList<XBAttribute>();
    private int attributePartSizeValue = 0;

    public XBSEventWriter() {
    }

    public XBSEventWriter(OutputStream outputStream) throws IOException {
        this();
        this.openStream(outputStream);
    }

    public XBSEventWriter(OutputStream outputStream, XBParserMode parserMode) throws IOException {
        this();
        this.parserMode = parserMode;
        this.openStream(outputStream);
    }

    private void openStream(OutputStream outputStream) throws IOException {
        this.stream = outputStream;
    }

    public void open(OutputStream outputStream) throws IOException {
        this.openStream(outputStream);
    }

    @Override
    public void close() throws XBProcessingException, IOException {
        this.stream.close();
    }

    public void closeXB() throws XBProcessingException, IOException {
        if (this.parserState != XBParserState.EOF && this.parserState != XBParserState.TAIL_DATA) {
            throw new XBParsingException("Unexpected end of stream", XBProcessingExceptionType.UNEXPECTED_END_OF_STREAM);
        }
        this.close();
    }

    @Override
    public void putXBToken(XBToken token) throws XBProcessingException, IOException {
        block0 : switch (token.getTokenType()) {
            case BEGIN: {
                if (this.parserState == XBParserState.START) {
                    if (this.parserMode != XBParserMode.SINGLE_BLOCK && this.parserMode != XBParserMode.SKIP_HEAD) {
                        XBHead.writeXBUPHead(this.stream);
                    }
                    this.parserState = XBParserState.BLOCK_BEGIN;
                } else if (this.parserState == XBParserState.ATTRIBUTE_PART || this.parserState == XBParserState.BLOCK_END) {
                    if (this.parserState == XBParserState.ATTRIBUTE_PART) {
                        this.flushAttributes();
                    }
                    this.parserState = XBParserState.BLOCK_BEGIN;
                }
                if (this.parserState == XBParserState.BLOCK_BEGIN) {
                    ++this.depthLevel;
                    this.terminationMode = ((XBBeginToken)token).getTerminationMode();
                    this.attributePartSizeValue = 0;
                    this.dataMode = null;
                    if (this.bufferedFromLevel >= 0) {
                        this.tokenBuffer.putXBToken(token);
                        this.sizeLimits.add(null);
                    } else if (this.terminationMode == XBBlockTerminationMode.SIZE_SPECIFIED) {
                        this.bufferedFromLevel = this.depthLevel;
                        this.tokenBuffer.putXBToken(token);
                        this.sizeLimits.add(null);
                    } else {
                        this.sizeLimits.add(null);
                    }
                    this.attributeList.clear();
                    break;
                }
                throw new XBParsingException("Unexpected begin of block", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
            case ATTRIBUTE: {
                if (this.parserState == XBParserState.BLOCK_BEGIN) {
                    this.parserState = XBParserState.ATTRIBUTE_PART;
                }
                if (this.parserState == XBParserState.ATTRIBUTE_PART) {
                    this.dataMode = XBBlockDataMode.NODE_BLOCK;
                    if (this.bufferedFromLevel >= 0) {
                        this.tokenBuffer.putXBToken(token);
                        break;
                    }
                    int attributeSize = ((XBAttributeToken)token).getAttribute().getSizeUB();
                    XBSEventWriter.shrinkStatus(this.sizeLimits, attributeSize);
                    this.attributePartSizeValue += attributeSize;
                    this.attributeList.add(((XBAttributeToken)token).getAttribute());
                    break;
                }
                throw new XBParsingException("Unexpected attribute", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
            case DATA: {
                if (this.depthLevel == 1 && (this.parserState == XBParserState.ATTRIBUTE_PART || this.parserState == XBParserState.DATA_PART || this.parserState == XBParserState.BLOCK_END)) {
                    if (this.parserMode == XBParserMode.SINGLE_BLOCK || this.parserMode == XBParserMode.SKIP_TAIL) {
                        throw new XBParsingException("Tail data present when not expected", XBProcessingExceptionType.UNEXPECTED_ORDER);
                    }
                    this.putXBToken(XBEndToken.create());
                    this.parserState = XBParserState.TAIL_DATA;
                    StreamUtils.copyInputStreamToOutputStream(((XBDataToken)token).getData(), this.stream);
                    break;
                }
                if (this.parserState != XBParserState.BLOCK_BEGIN) {
                    throw new XBParsingException("Unexpected data token", XBProcessingExceptionType.UNEXPECTED_ORDER);
                }
                this.dataMode = XBBlockDataMode.DATA_BLOCK;
                if (this.bufferedFromLevel >= 0) {
                    this.tokenBuffer.putXBToken(token);
                } else if (this.terminationMode == XBBlockTerminationMode.SIZE_SPECIFIED) {
                    FixedDataOutputStreamWrapper streamWrapper = new FixedDataOutputStreamWrapper(this.stream, 0);
                    StreamUtils.copyInputStreamToOutputStream(((XBDataToken)token).getData(), streamWrapper);
                    int dataSize = (int)((FinishableStream)streamWrapper).finish();
                    XBSEventWriter.shrinkStatus(this.sizeLimits, dataSize);
                } else {
                    UBNat32 attributePartSize = new UBNat32(1);
                    attributePartSize.toStreamUB(this.stream);
                    UBENat32 dataPartSize = new UBENat32();
                    dataPartSize.setInfinity();
                    dataPartSize.toStreamUB(this.stream);
                    XBSEventWriter.shrinkStatus(this.sizeLimits, 2);
                    TerminatedDataOutputStreamWrapper streamWrapper = new TerminatedDataOutputStreamWrapper(this.stream);
                    StreamUtils.copyInputStreamToOutputStream(((XBDataToken)token).getData(), streamWrapper);
                    int dataSize = (int)((FinishableStream)streamWrapper).finish();
                    XBSEventWriter.shrinkStatus(this.sizeLimits, dataSize);
                }
                this.parserState = XBParserState.DATA_PART;
                break;
            }
            case END: {
                switch (this.parserState) {
                    case TAIL_DATA: {
                        this.parserState = XBParserState.EOF;
                        break block0;
                    }
                    case ATTRIBUTE_PART: {
                        this.flushAttributes();
                    }
                    case BLOCK_END: 
                    case DATA_PART: {
                        if (this.bufferedFromLevel >= 0) {
                            this.tokenBuffer.putXBToken(XBEndToken.create());
                            if (this.bufferedFromLevel == this.depthLevel) {
                                this.tokenBuffer.write(this.stream);
                                this.bufferedFromLevel = -1;
                            }
                        } else {
                            if (this.dataMode == XBBlockDataMode.NODE_BLOCK && this.sizeLimits.get(this.depthLevel - 1) == null) {
                                this.stream.write(0);
                            }
                            XBSEventWriter.decreaseStatus(this.sizeLimits);
                        }
                        --this.depthLevel;
                        this.parserState = this.depthLevel == 0 ? XBParserState.EOF : XBParserState.BLOCK_END;
                        break block0;
                    }
                }
                throw new XBParsingException("Unexpected end token", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
        }
    }

    private void flushAttributes() throws IOException {
        if (this.bufferedFromLevel == -1) {
            ++this.attributePartSizeValue;
            UBNat32 attributePartSize = new UBNat32(this.attributePartSizeValue);
            XBSEventWriter.shrinkStatus(this.sizeLimits, attributePartSize.getSizeUB() + 1 + 1);
            attributePartSize.toStreamUB(this.stream);
            UBENat32 dataPartSize = new UBENat32();
            dataPartSize.setInfinity();
            dataPartSize.toStreamUB(this.stream);
            for (XBAttribute attribute : this.attributeList) {
                attribute.toStreamUB(this.stream);
            }
            this.attributeList.clear();
        }
    }

    private static void shrinkStatus(List<Integer> sizeLimits, int value) throws XBParsingException {
        for (int depth = 0; depth < sizeLimits.size(); ++depth) {
            Integer limit = sizeLimits.get(depth);
            if (limit == null) continue;
            if (limit < value) {
                throw new XBParsingException("Block overflow", XBProcessingExceptionType.BLOCK_OVERFLOW);
            }
            sizeLimits.set(depth, limit - value);
        }
    }

    private static void decreaseStatus(List<Integer> sizeLimits) {
        Integer levelValue = sizeLimits.remove(sizeLimits.size() - 1);
        if (levelValue != null && levelValue != 0) {
            throw new XBParsingException("Block overflow", XBProcessingExceptionType.BLOCK_OVERFLOW);
        }
    }
}

