/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token.convert;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.basic.XBListener;
import org.exbin.xbup.core.parser.basic.XBSListener;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBEndToken;
import org.exbin.xbup.core.parser.token.XBSBeginToken;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.ubnumber.UBNatural;

@ParametersAreNonnullByDefault
public class XBListenerToToken
implements XBListener,
XBSListener {
    @Nullable
    private XBToken token = null;

    @Nullable
    public XBToken getToken() {
        return this.token;
    }

    public void setToken(@Nullable XBToken token) {
        this.token = token;
    }

    @Override
    public void beginXB(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
        this.token = XBBeginToken.create(terminationMode);
    }

    @Override
    public void beginXB(XBBlockTerminationMode terminationMode, @Nullable UBNatural blockSize) throws XBProcessingException, IOException {
        this.token = XBSBeginToken.create(terminationMode, blockSize);
    }

    @Override
    public void attribXB(XBAttribute value) throws XBProcessingException, IOException {
        this.token = XBAttributeToken.create(value);
    }

    @Override
    public void dataXB(InputStream data) throws XBProcessingException, IOException {
        this.token = XBDataToken.create(data);
    }

    @Override
    public void endXB() throws XBProcessingException, IOException {
        this.token = XBEndToken.create();
    }

    public static void tokenToListener(XBToken token, XBListener listener) throws XBProcessingException, IOException {
        switch (token.getTokenType()) {
            case BEGIN: {
                if (token instanceof XBSBeginToken && listener instanceof XBSListener) {
                    ((XBSListener)listener).beginXB(((XBSBeginToken)token).getTerminationMode(), ((XBSBeginToken)token).getBlockSize());
                    break;
                }
                listener.beginXB(((XBBeginToken)token).getTerminationMode());
                break;
            }
            case ATTRIBUTE: {
                listener.attribXB(((XBAttributeToken)token).getAttribute());
                break;
            }
            case DATA: {
                listener.dataXB(((XBDataToken)token).getData());
                break;
            }
            case END: {
                listener.endXB();
            }
        }
    }
}

