/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTokenType;

@ParametersAreNonnullByDefault
public abstract class XBTDataToken
implements XBTToken {
    @Nullable
    private static XBTEmptyDataToken instance = null;

    @Nonnull
    public abstract InputStream getData();

    public abstract boolean isEmpty();

    @Override
    @Nonnull
    public XBTTokenType getTokenType() {
        return XBTTokenType.DATA;
    }

    @Nonnull
    public static XBTDataToken create(InputStream data) {
        return new XBTDataTokenImpl(data);
    }

    @Nonnull
    public static XBTDataToken createEmptyToken() {
        if (instance == null) {
            instance = new XBTEmptyDataToken();
        }
        return instance;
    }

    @ParametersAreNonnullByDefault
    private static class XBTEmptyDataToken
    extends XBTDataToken {
        private XBTEmptyDataToken() {
        }

        @Override
        @Nonnull
        public InputStream getData() {
            return new ByteArrayInputStream(new byte[0]);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }

    @ParametersAreNonnullByDefault
    private static class XBTDataTokenImpl
    extends XBTDataToken {
        @Nonnull
        private final InputStream data;

        private XBTDataTokenImpl(InputStream data) {
            this.data = data;
        }

        @Override
        @Nonnull
        public InputStream getData() {
            return this.data;
        }

        @Override
        public boolean isEmpty() {
            try {
                return this.data.available() == 0;
            }
            catch (IOException ex) {
                Logger.getLogger(XBDataToken.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
    }
}

