/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.basic.wrapper;

import java.io.IOException;
import java.io.InputStream;
import org.exbin.xbup.core.parser.XBParsingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.stream.FinishableStream;

public class FixedDataInputStreamWrapper
extends InputStream
implements FinishableStream {
    private final InputStream source;
    private int remaining = 0;
    private int length = 0;

    public FixedDataInputStreamWrapper(InputStream source, int fixedLength) throws IOException {
        this.source = source;
        this.remaining = fixedLength;
    }

    @Override
    public int read() throws IOException {
        if (this.remaining == 0) {
            return -1;
        }
        int read = this.source.read();
        if (read >= 0) {
            ++this.length;
            --this.remaining;
        } else {
            this.remaining = 0;
        }
        return read;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        int read;
        if (this.remaining == 0) {
            return -1;
        }
        int n = read = buffer.length > this.remaining ? this.source.read(buffer, 0, this.remaining) : this.source.read(buffer);
        if (read > 0) {
            this.length += read;
            this.remaining -= read;
        }
        return read;
    }

    @Override
    public int read(byte[] buffer, int off, int len) throws IOException {
        if (this.remaining == 0) {
            return -1;
        }
        int read = this.source.read(buffer, off, len > this.remaining ? this.remaining : len);
        if (read > 0) {
            this.length += read;
            this.remaining -= read;
        }
        return read;
    }

    @Override
    public long finish() throws IOException, XBParsingException {
        if (this.remaining > 0) {
            int read;
            byte[] buf = new byte[1024];
            while (this.remaining > 0 && (read = this.source.read(buf, 0, this.remaining < 1024 ? this.remaining : 1024)) > 0) {
                this.length += read;
                this.remaining -= read;
            }
            if (this.remaining > 0) {
                throw new XBParsingException("Unexpected end of stream", XBProcessingExceptionType.UNEXPECTED_END_OF_STREAM);
            }
        }
        return this.length;
    }

    @Override
    public int available() throws IOException {
        return this.remaining > 0 ? 1 : 0;
    }

    @Override
    public long getLength() {
        return this.length;
    }
}

