/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.basic.convert;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.exbin.xbup.core.block.XBBasicBlockType;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBDBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.declaration.XBContext;
import org.exbin.xbup.core.block.declaration.XBLevelContext;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBTFilter;
import org.exbin.xbup.core.parser.basic.XBTListener;
import org.exbin.xbup.core.parser.token.XBAttribute;

public class XBTTypeUndeclaringFilter
implements XBTFilter {
    private XBCatalog catalog = null;
    private XBTListener listener = null;
    private final List<XBLevelContext> contexts = new ArrayList<XBLevelContext>();
    private XBLevelContext currentContext = null;
    private int documentDepth = 0;
    private XBBlockTerminationMode beginTerminationMode;

    public XBTTypeUndeclaringFilter(XBCatalog catalog) {
        this.catalog = catalog;
    }

    public XBTTypeUndeclaringFilter(XBCatalog catalog, XBContext initialContext) {
        this(catalog);
        this.currentContext = new XBLevelContext(catalog, initialContext, 0);
    }

    @Override
    public void beginXBT(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
        if (this.currentContext != null && !this.currentContext.isDeclarationFinished()) {
            this.currentContext.beginXBT(terminationMode);
        }
        this.listener.beginXBT(terminationMode);
        ++this.documentDepth;
        this.beginTerminationMode = terminationMode;
    }

    @Override
    public void typeXBT(XBBlockType blockType) throws XBProcessingException, IOException {
        if (this.currentContext != null && !this.currentContext.isDeclarationFinished()) {
            this.currentContext.typeXBT(blockType);
        }
        if (blockType.getAsBasicType() == XBBasicBlockType.DECLARATION) {
            ++this.documentDepth;
            this.contexts.add(this.currentContext);
            this.currentContext = new XBLevelContext(this.catalog, this.currentContext == null ? null : this.currentContext.getContext(), this.documentDepth);
            this.currentContext.beginXBT(this.beginTerminationMode);
            this.currentContext.typeXBT(blockType);
            this.listener.typeXBT(blockType);
        } else if (blockType instanceof XBDBlockType) {
            XBFixedBlockType fixedType = this.currentContext.getContext().getFixedBlockType((XBDBlockType)blockType);
            if (fixedType == null) {
                throw new XBProcessingException("Unable to match block type", XBProcessingExceptionType.BLOCK_TYPE_MISMATCH);
            }
            this.listener.typeXBT(fixedType);
        } else {
            this.listener.typeXBT(blockType);
        }
    }

    @Override
    public void attribXBT(XBAttribute value) throws XBProcessingException, IOException {
        if (this.currentContext != null && !this.currentContext.isDeclarationFinished()) {
            this.currentContext.attribXBT(value);
        }
        this.listener.attribXBT(value);
    }

    @Override
    public void dataXBT(InputStream data) throws XBProcessingException, IOException {
        if (this.currentContext != null && !this.currentContext.isDeclarationFinished()) {
            this.currentContext.dataXBT(data);
        }
        this.listener.dataXBT(data);
    }

    @Override
    public void endXBT() throws XBProcessingException, IOException {
        if (this.currentContext != null && !this.currentContext.isDeclarationFinished()) {
            this.currentContext.endXBT();
        }
        this.listener.endXBT();
        --this.documentDepth;
        if (this.currentContext != null && this.currentContext.getDepthLevel() > this.documentDepth) {
            this.currentContext = this.contexts.size() > 0 ? this.contexts.remove(this.contexts.size() - 1) : null;
        }
    }

    @Override
    public void attachXBTListener(XBTListener listener) {
        this.listener = listener;
    }
}

