/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.basic.convert;

import java.io.IOException;
import java.io.InputStream;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.parser.XBParsingException;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBListener;
import org.exbin.xbup.core.parser.basic.XBProducer;
import org.exbin.xbup.core.parser.basic.XBSListener;
import org.exbin.xbup.core.parser.basic.XBTListener;
import org.exbin.xbup.core.parser.basic.XBTSListener;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.ubnumber.UBNatural;

public class XBTToXBConvertor
implements XBTListener,
XBTSListener,
XBProducer {
    private XBListener listener;
    private UBNatural blockIdAttribute;

    public XBTToXBConvertor() {
    }

    public XBTToXBConvertor(XBListener listener) {
        this();
        this.listener = listener;
    }

    @Override
    public void beginXBT(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
        if (this.blockIdAttribute != null) {
            this.listener.attribXB(this.blockIdAttribute);
            this.blockIdAttribute = null;
        }
        this.listener.beginXB(terminationMode);
    }

    @Override
    public void beginXBT(XBBlockTerminationMode terminationMode, UBNatural blockSize) throws XBProcessingException, IOException {
        if (this.blockIdAttribute != null) {
            this.listener.attribXB(this.blockIdAttribute);
            this.blockIdAttribute = null;
        }
        if (this.listener instanceof XBSListener) {
            ((XBSListener)this.listener).beginXB(terminationMode, blockSize);
        } else {
            this.listener.beginXB(terminationMode);
        }
    }

    @Override
    public void typeXBT(XBBlockType type) throws XBProcessingException, IOException {
        if (this.blockIdAttribute != null) {
            this.listener.attribXB(this.blockIdAttribute);
            this.blockIdAttribute = null;
        }
        if (!(type instanceof XBFixedBlockType)) {
            throw new XBParsingException("Unable to parse non-static block type", XBProcessingExceptionType.UNSUPPORTED);
        }
        this.listener.attribXB(((XBFixedBlockType)type).getGroupID());
        this.blockIdAttribute = ((XBFixedBlockType)type).getBlockID();
    }

    @Override
    public void attribXBT(XBAttribute attribute) throws XBProcessingException, IOException {
        if (this.blockIdAttribute != null) {
            this.listener.attribXB(this.blockIdAttribute);
            this.blockIdAttribute = null;
        }
        this.listener.attribXB(attribute);
    }

    @Override
    public void dataXBT(InputStream data) throws XBProcessingException, IOException {
        if (this.blockIdAttribute != null) {
            this.listener.attribXB(this.blockIdAttribute);
            this.blockIdAttribute = null;
        }
        this.listener.dataXB(data);
    }

    @Override
    public void endXBT() throws XBProcessingException, IOException {
        if (this.blockIdAttribute != null) {
            this.listener.attribXB(this.blockIdAttribute);
            this.blockIdAttribute = null;
        }
        this.listener.endXB();
    }

    @Override
    public void attachXBListener(XBListener listener) {
        this.listener = listener;
    }
}

