/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.basic.convert;

import java.io.IOException;
import java.io.InputStream;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.parser.XBParsingException;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBTMatchingProvider;
import org.exbin.xbup.core.parser.basic.XBTProvider;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.XBTAttributeToken;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTDataToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTokenType;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.parser.token.convert.XBTListenerToToken;

public class XBTDefaultMatchingProvider
implements XBTMatchingProvider {
    private final XBTProvider provider;
    private final XBTListenerToToken tokenListener = new XBTListenerToToken();

    public XBTDefaultMatchingProvider(XBTProvider provider) {
        this.provider = provider;
    }

    @Override
    public XBBlockTerminationMode matchBeginXBT() throws XBProcessingException, IOException {
        XBTToken token = this.pullToken();
        if (token.getTokenType() == XBTTokenType.BEGIN) {
            return ((XBTBeginToken)token).getTerminationMode();
        }
        throw new XBParsingException("Unexpected event order", XBProcessingExceptionType.UNEXPECTED_ORDER);
    }

    @Override
    public void matchBeginXBT(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
        XBTToken token = this.pullToken();
        if (token.getTokenType() != XBTTokenType.BEGIN || terminationMode != ((XBTBeginToken)token).getTerminationMode()) {
            throw new XBParsingException("Unexpected event order", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
    }

    @Override
    public XBBlockType matchTypeXBT() throws XBProcessingException, IOException {
        XBTToken token = this.pullToken();
        if (token.getTokenType() == XBTTokenType.TYPE) {
            return ((XBTTypeToken)token).getBlockType();
        }
        throw new XBParsingException("Unexpected event order", XBProcessingExceptionType.UNEXPECTED_ORDER);
    }

    @Override
    public void matchTypeXBT(XBBlockType type) throws XBProcessingException, IOException {
        XBTToken token = this.pullToken();
        if (token.getTokenType() != XBTTokenType.TYPE || !((XBTTypeToken)token).getBlockType().equals(type)) {
            throw new XBParsingException("Unexpected event order", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
    }

    @Override
    public XBAttribute matchAttribXBT() throws XBProcessingException, IOException {
        XBTToken token = this.pullToken();
        if (token.getTokenType() == XBTTokenType.ATTRIBUTE) {
            return ((XBTAttributeToken)token).getAttribute();
        }
        throw new XBParsingException("Unexpected event order", XBProcessingExceptionType.UNEXPECTED_ORDER);
    }

    @Override
    public void matchAttribXBT(XBAttribute value) throws XBProcessingException, IOException {
        XBTToken token = this.pullToken();
        if (token.getTokenType() != XBTTokenType.ATTRIBUTE || ((XBTAttributeToken)token).getAttribute().getNaturalLong() != value.getNaturalLong()) {
            throw new XBParsingException("Unexpected event order", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
    }

    @Override
    public InputStream matchDataXBT() throws XBProcessingException, IOException {
        XBTToken token = this.pullToken();
        if (token.getTokenType() == XBTTokenType.DATA) {
            return ((XBTDataToken)token).getData();
        }
        throw new XBParsingException("Unexpected event order", XBProcessingExceptionType.UNEXPECTED_ORDER);
    }

    @Override
    public void matchDataXBT(InputStream data) throws XBProcessingException, IOException {
        XBTToken token = this.pullToken();
        if (token.getTokenType() != XBTTokenType.DATA || data != ((XBTDataToken)token).getData()) {
            throw new XBParsingException("Unexpected event order", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
    }

    @Override
    public void matchEndXBT() throws XBProcessingException, IOException {
        XBTToken token = this.pullToken();
        if (token.getTokenType() == XBTTokenType.END) {
            return;
        }
        throw new XBParsingException("Unexpected event order", XBProcessingExceptionType.UNEXPECTED_ORDER);
    }

    public XBTToken pullToken() throws XBProcessingException, IOException {
        this.provider.produceXBT(this.tokenListener);
        return this.tokenListener.getToken();
    }
}

