/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.basic.convert;

import java.io.IOException;
import java.io.InputStream;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.parser.XBParsingException;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBMatchingProvider;
import org.exbin.xbup.core.parser.basic.XBProvider;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.parser.token.XBTokenType;
import org.exbin.xbup.core.parser.token.convert.XBListenerToToken;
import org.exbin.xbup.core.util.StreamUtils;

public class XBDefaultMatchingProvider
implements XBMatchingProvider {
    private final XBProvider provider;
    private final XBListenerToToken tokenListener = new XBListenerToToken();

    public XBDefaultMatchingProvider(XBProvider provider) {
        this.provider = provider;
    }

    @Override
    public XBBlockTerminationMode matchBeginXB() throws XBProcessingException, IOException {
        XBToken token = this.pullToken();
        if (token.getTokenType() == XBTokenType.BEGIN) {
            return ((XBBeginToken)token).getTerminationMode();
        }
        throw new XBParsingException("Unexpected event order", XBProcessingExceptionType.UNEXPECTED_ORDER);
    }

    @Override
    public void matchBeginXB(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
        XBToken token = this.pullToken();
        if (token.getTokenType() != XBTokenType.BEGIN || terminationMode != ((XBBeginToken)token).getTerminationMode()) {
            throw new XBParsingException("Unexpected event order", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
    }

    @Override
    public XBAttribute matchAttribXB() throws XBProcessingException, IOException {
        XBToken token = this.pullToken();
        if (token.getTokenType() == XBTokenType.ATTRIBUTE) {
            return ((XBAttributeToken)token).getAttribute();
        }
        throw new XBParsingException("Unexpected event order", XBProcessingExceptionType.UNEXPECTED_ORDER);
    }

    @Override
    public void matchAttribXB(XBAttribute value) throws XBProcessingException, IOException {
        XBToken token = this.pullToken();
        if (token.getTokenType() != XBTokenType.ATTRIBUTE || ((XBAttributeToken)token).getAttribute().getNaturalLong() != value.getNaturalLong()) {
            throw new XBParsingException("Unexpected event order", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
    }

    @Override
    public InputStream matchDataXB() throws XBProcessingException, IOException {
        XBToken token = this.pullToken();
        if (token.getTokenType() == XBTokenType.DATA) {
            return ((XBDataToken)token).getData();
        }
        throw new XBParsingException("Unexpected event order", XBProcessingExceptionType.UNEXPECTED_ORDER);
    }

    @Override
    public void matchDataXB(InputStream data) throws XBProcessingException, IOException {
        XBToken token = this.pullToken();
        if (token.getTokenType() != XBTokenType.DATA || !StreamUtils.compareStreams(data, ((XBDataToken)token).getData())) {
            throw new XBParsingException("Unexpected event order", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
    }

    @Override
    public void matchEndXB() throws XBProcessingException, IOException {
        XBToken token = this.pullToken();
        if (token.getTokenType() != XBTokenType.END) {
            throw new XBParsingException("Unexpected event order", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
    }

    public XBToken pullToken() throws XBProcessingException, IOException {
        this.provider.produceXB(this.tokenListener);
        return this.tokenListener.getToken();
    }
}

