/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.basic.convert;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBConsumer;
import org.exbin.xbup.core.parser.basic.XBListener;
import org.exbin.xbup.core.parser.basic.XBProvider;
import org.exbin.xbup.core.parser.basic.XBSListener;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBEndToken;
import org.exbin.xbup.core.parser.token.XBSBeginToken;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.parser.token.convert.XBListenerToToken;
import org.exbin.xbup.core.ubnumber.UBNatural;

public class XBConsumerToListener
implements XBSListener {
    private List<XBToken> tokens = new LinkedList<XBToken>();

    public XBConsumerToListener(XBConsumer consumer) {
        if (consumer != null) {
            consumer.attachXBProvider(new XBProvider(){

                @Override
                public void produceXB(XBListener listener) throws XBProcessingException, IOException {
                    if (XBConsumerToListener.this.tokens.isEmpty()) {
                        throw new XBProcessingException("End of data reached", XBProcessingExceptionType.UNEXPECTED_END_OF_STREAM);
                    }
                    XBToken token = (XBToken)XBConsumerToListener.this.tokens.remove(0);
                    XBListenerToToken.tokenToListener(token, listener);
                }
            });
        }
    }

    @Override
    public void beginXB(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
        this.tokens.add(XBBeginToken.create(terminationMode));
    }

    @Override
    public void beginXB(XBBlockTerminationMode terminationMode, UBNatural blockSize) throws XBProcessingException, IOException {
        this.tokens.add(XBSBeginToken.create(terminationMode, blockSize));
    }

    @Override
    public void attribXB(XBAttribute value) throws XBProcessingException, IOException {
        this.tokens.add(XBAttributeToken.create(value));
    }

    @Override
    public void dataXB(InputStream data) throws XBProcessingException, IOException {
        this.tokens.add(XBDataToken.create(data));
    }

    @Override
    public void endXB() throws XBProcessingException, IOException {
        this.tokens.add(XBEndToken.create());
    }

    public List<XBToken> getTokens() {
        return this.tokens;
    }
}

