/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.basic;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.parser.XBParserMode;
import org.exbin.xbup.core.parser.XBParserState;
import org.exbin.xbup.core.parser.XBParsingException;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBHead;
import org.exbin.xbup.core.parser.basic.XBListener;
import org.exbin.xbup.core.parser.basic.XBProvider;
import org.exbin.xbup.core.parser.basic.wrapper.FixedDataInputStreamWrapper;
import org.exbin.xbup.core.parser.basic.wrapper.TailDataInputStreamWrapper;
import org.exbin.xbup.core.parser.basic.wrapper.TerminatedDataInputStreamWrapper;
import org.exbin.xbup.core.stream.FinishableStream;
import org.exbin.xbup.core.ubnumber.type.UBENat32;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

public class XBProviderReader
implements XBProvider {
    private XBParserState parserState;
    private XBParserMode parserMode = XBParserMode.FULL;
    private InputStream source;
    private FinishableStream dataWrapper;
    private final List<Integer> sizeLimits = new ArrayList<Integer>();
    private int attributePartSizeValue;
    private Integer dataPartSizeValue;

    public XBProviderReader() {
        this.resetParser();
    }

    public XBProviderReader(InputStream inputStream) throws IOException {
        this();
        this.openStream(inputStream);
    }

    public XBProviderReader(InputStream inputStream, XBParserMode parserMode) throws IOException {
        this();
        this.parserMode = parserMode;
        this.openStream(inputStream);
    }

    private void openStream(InputStream stream) throws IOException {
        this.source = stream;
        this.reset();
    }

    private void resetParser() {
        this.dataWrapper = null;
        this.parserState = XBParserState.START;
        this.sizeLimits.clear();
        this.attributePartSizeValue = 0;
    }

    public void open(InputStream stream) throws IOException {
        this.source = stream;
        this.reset();
    }

    public void reset() throws IOException {
        this.resetParser();
    }

    public void close() throws IOException {
        this.source.close();
    }

    private static void shrinkStatus(List<Integer> sizeLimits, int value) throws XBParsingException {
        for (int depthLevel = 0; depthLevel < sizeLimits.size(); ++depthLevel) {
            Integer limit = sizeLimits.get(depthLevel);
            if (limit == null) continue;
            if (limit < value) {
                throw new XBParsingException("Block overflow", XBProcessingExceptionType.BLOCK_OVERFLOW);
            }
            sizeLimits.set(depthLevel, limit - value);
        }
    }

    protected int getLevel() {
        return this.sizeLimits.size();
    }

    public boolean isFinished() {
        return this.parserState == XBParserState.EOF;
    }

    public XBParserState getParserState() {
        return this.parserState;
    }

    public String toString() {
        String retValue = super.toString();
        return retValue;
    }

    @Override
    public void produceXB(XBListener listener) throws XBProcessingException, IOException {
        if (this.dataWrapper != null) {
            this.dataWrapper.finish();
            XBProviderReader.shrinkStatus(this.sizeLimits, (int)this.dataWrapper.getLength());
            this.dataWrapper = null;
        }
        if (this.parserState == XBParserState.START) {
            if (this.parserMode != XBParserMode.SINGLE_BLOCK && this.parserMode != XBParserMode.SKIP_HEAD) {
                XBHead.checkXBUPHead(this.source);
            }
            this.parserState = XBParserState.BLOCK_BEGIN;
        }
        switch (this.parserState) {
            case BLOCK_BEGIN: {
                UBNat32 attrPartSize = new UBNat32();
                int headSize = attrPartSize.fromStreamUB(this.source);
                XBProviderReader.shrinkStatus(this.sizeLimits, headSize);
                if (attrPartSize.getLong() == 0L) {
                    if (this.sizeLimits.isEmpty() || this.sizeLimits.get(this.sizeLimits.size() - 1) != null) {
                        throw new XBParsingException("Unexpected terminator", XBProcessingExceptionType.UNEXPECTED_TERMINATOR);
                    }
                    this.sizeLimits.remove(this.sizeLimits.size() - 1);
                    this.parserState = XBParserState.BLOCK_END;
                } else {
                    this.attributePartSizeValue = attrPartSize.getInt();
                    XBProviderReader.shrinkStatus(this.sizeLimits, this.attributePartSizeValue);
                    UBENat32 dataPartSize = new UBENat32();
                    int dataPartSizeLength = dataPartSize.fromStreamUB(this.source);
                    Integer n = this.dataPartSizeValue = dataPartSize.isInfinity() ? null : Integer.valueOf(dataPartSize.getInt());
                    if (this.attributePartSizeValue == dataPartSizeLength) {
                        this.parserState = XBParserState.DATA_PART;
                    } else {
                        this.attributePartSizeValue -= dataPartSizeLength;
                        if (this.attributePartSizeValue > 0) {
                            this.parserState = XBParserState.ATTRIBUTE_PART;
                        } else if (this.dataPartSizeValue == null || this.dataPartSizeValue > 0) {
                            this.sizeLimits.add(this.dataPartSizeValue);
                            this.parserState = XBParserState.BLOCK_BEGIN;
                        } else {
                            this.parserState = XBParserState.BLOCK_END;
                        }
                    }
                    listener.beginXB(this.dataPartSizeValue == null ? XBBlockTerminationMode.TERMINATED_BY_ZERO : XBBlockTerminationMode.SIZE_SPECIFIED);
                    break;
                }
            }
            case TAIL_DATA: 
            case BLOCK_END: {
                if (this.sizeLimits.isEmpty()) {
                    if (this.parserState == XBParserState.BLOCK_END && this.parserMode != XBParserMode.SINGLE_BLOCK && this.parserMode != XBParserMode.SKIP_TAIL) {
                        this.parserState = XBParserState.TAIL_DATA;
                        TailDataInputStreamWrapper wrapper = new TailDataInputStreamWrapper(this.source);
                        if (wrapper.available() > 0) {
                            listener.dataXB(wrapper);
                            break;
                        }
                    }
                    this.parserState = XBParserState.EOF;
                } else if (this.sizeLimits.get(this.sizeLimits.size() - 1) == null || this.sizeLimits.get(this.sizeLimits.size() - 1) > 0) {
                    this.parserState = XBParserState.BLOCK_BEGIN;
                } else {
                    this.sizeLimits.remove(this.sizeLimits.size() - 1);
                }
                listener.endXB();
                break;
            }
            case ATTRIBUTE_PART: {
                UBNat32 attribute = new UBNat32();
                int attributeLength = attribute.fromStreamUB(this.source);
                if (attributeLength > this.attributePartSizeValue) {
                    throw new XBParsingException("Attribute overflow", XBProcessingExceptionType.ATTRIBUTE_OVERFLOW);
                }
                this.attributePartSizeValue -= attributeLength;
                if (this.attributePartSizeValue == 0) {
                    if (this.dataPartSizeValue == null || this.dataPartSizeValue > 0) {
                        this.sizeLimits.add(this.dataPartSizeValue);
                        this.parserState = XBParserState.BLOCK_BEGIN;
                    } else {
                        this.parserState = XBParserState.BLOCK_END;
                    }
                }
                listener.attribXB(attribute);
                break;
            }
            case DATA_PART: {
                this.dataWrapper = this.dataPartSizeValue == null ? new TerminatedDataInputStreamWrapper(this.source) : new FixedDataInputStreamWrapper(this.source, this.dataPartSizeValue);
                this.parserState = XBParserState.BLOCK_END;
                listener.dataXB((InputStream)((Object)this.dataWrapper));
                break;
            }
            case EOF: {
                throw new XBParsingException("Reading After End", XBProcessingExceptionType.READING_AFTER_END);
            }
            default: {
                throw new XBParsingException("Unexpected pull item type", XBProcessingExceptionType.UNKNOWN);
            }
        }
    }
}

