/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.basic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.annotation.Nonnull;
import org.exbin.xbup.core.parser.XBParsingException;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;

public class XBHead {
    public static final String XBUP_MIME_TYPE = "others/x-xbup";
    public static final byte[] XB_HEADER_DEVELOPMENT_VERSION = new byte[]{-2, 0, 88, 66, 0, 2};
    private static final String DEFAULT_BUNLDE_PACKAGE = "sun.util.logging.resources.logging";
    public static final Level XB_DEBUG_LEVEL = new XBDebugLevel("XB_DEBUG", 658, "sun.util.logging.resources.logging");

    public static int writeXBUPHead(OutputStream stream) throws IOException {
        stream.write(XB_HEADER_DEVELOPMENT_VERSION);
        return XB_HEADER_DEVELOPMENT_VERSION.length;
    }

    public static int getXBUPHeadSize() {
        return XB_HEADER_DEVELOPMENT_VERSION.length;
    }

    public static int checkXBUPHead(@Nonnull InputStream stream) throws IOException, XBProcessingException {
        byte[] head = new byte[XB_HEADER_DEVELOPMENT_VERSION.length];
        int offset = 0;
        int redByte = 0;
        for (int length = XB_HEADER_DEVELOPMENT_VERSION.length; redByte < length; length -= redByte) {
            redByte = stream.read(head, offset, length);
            if (redByte < 0) {
                throw new XBParsingException("Corrupted or missing header", XBProcessingExceptionType.CORRUPTED_HEADER);
            }
            offset += redByte;
        }
        if (!Arrays.equals(XB_HEADER_DEVELOPMENT_VERSION, head)) {
            String header = "";
            for (int i = 0; i < head.length; ++i) {
                header = header + Integer.toString((head[i] & 0xFF) + 256, 16).substring(1);
            }
            throw new XBParsingException("Unsupported header: 0x" + header, XBProcessingExceptionType.CORRUPTED_HEADER);
        }
        return XB_HEADER_DEVELOPMENT_VERSION.length;
    }

    public static class XBLogHandler
    extends Handler {
        boolean verboseMode;

        public XBLogHandler(boolean verboseMode) {
            this.verboseMode = verboseMode;
        }

        @Override
        public void publish(LogRecord record) {
            if (record.getLevel() == XB_DEBUG_LEVEL && this.verboseMode) {
                System.out.println("DEBUG: " + record.getMessage());
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }

    private static class XBDebugLevel
    extends Level {
        public XBDebugLevel(String string, int i, String defaultBundle) {
            super(string, i, defaultBundle);
        }
    }
}

