/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.block.definition.catalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.exbin.xbup.core.block.XBBasicBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.definition.XBRevisionDef;
import org.exbin.xbup.core.block.definition.XBRevisionParam;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCRev;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.service.XBCRevService;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.sequence.XBListJoinSerializable;
import org.exbin.xbup.core.ubnumber.UBNatural;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

public class XBCRevisionDef
implements XBRevisionDef,
XBPSequenceSerializable {
    private final XBCatalog catalog;
    private final XBCSpec spec;

    public XBCRevisionDef(XBCatalog catalog, XBCSpec spec) {
        this.catalog = catalog;
        this.spec = spec;
    }

    @Override
    public List<XBRevisionParam> getRevParams() {
        ArrayList<XBRevisionParam> result = new ArrayList<XBRevisionParam>();
        XBCRevService revService = this.catalog.getCatalogService(XBCRevService.class);
        for (XBCRev rev : revService.getRevs(this.spec)) {
            result.add(new XBRevisionParam(rev.getXBLimit()));
        }
        return result;
    }

    public XBRevisionParam getRevParam(int position) {
        XBCRevService revService = this.catalog.getCatalogService(XBCRevService.class);
        XBCRev rev = revService.getRev(this.spec, position);
        XBRevisionParam revisionParam = new XBRevisionParam(rev.getXBLimit());
        return revisionParam;
    }

    @Override
    public int getRevisionLimit(long revision) {
        XBCRevService revService = this.catalog.getCatalogService(XBCRevService.class);
        return (int)revService.getRevsLimitSum(this.spec, revision);
    }

    @Override
    public void serializeXB(XBPSequenceSerialHandler serial) throws XBProcessingException, IOException {
        serial.begin();
        serial.matchType(new XBFixedBlockType(XBBasicBlockType.REVISION_DEFINITION));
        serial.listJoin(new XBListJoinSerializable(){
            private int position = 0;

            @Override
            public UBNatural getSize() {
                XBCRevService revService = XBCRevisionDef.this.catalog.getCatalogService(XBCRevService.class);
                return new UBNat32(revService.getRevsCount(XBCRevisionDef.this.spec));
            }

            @Override
            public void setSize(UBNatural count) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void reset() {
                this.position = 0;
            }

            @Override
            public XBSerializable next() {
                XBRevisionParam revParam = XBCRevisionDef.this.getRevParam(this.position);
                ++this.position;
                return revParam;
            }
        });
        serial.end();
    }
}

