/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.block.definition.catalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.exbin.xbup.core.block.XBBasicBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.declaration.catalog.XBCBlockDecl;
import org.exbin.xbup.core.block.definition.XBBlockDef;
import org.exbin.xbup.core.block.definition.XBBlockParam;
import org.exbin.xbup.core.block.definition.XBBlockParamConsist;
import org.exbin.xbup.core.block.definition.XBBlockParamJoin;
import org.exbin.xbup.core.block.definition.XBBlockParamListConsist;
import org.exbin.xbup.core.block.definition.XBBlockParamListJoin;
import org.exbin.xbup.core.block.definition.XBRevisionDef;
import org.exbin.xbup.core.block.definition.catalog.XBCRevisionDef;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCBlockRev;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCRev;
import org.exbin.xbup.core.catalog.base.XBCSpecDef;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPInputSerialHandler;
import org.exbin.xbup.core.serial.param.XBPOutputSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBPSerializable;
import org.exbin.xbup.core.serial.sequence.XBListConsistSerializable;
import org.exbin.xbup.core.ubnumber.UBENatural;
import org.exbin.xbup.core.ubnumber.type.UBENat32;

public class XBCBlockDef
implements XBBlockDef,
XBPSequenceSerializable {
    private final XBCatalog catalog;
    private final XBCBlockSpec blockSpec;

    public XBCBlockDef(XBCatalog catalog, XBCBlockSpec blockSpec) {
        this.catalog = catalog;
        this.blockSpec = blockSpec;
    }

    @Override
    public List<XBBlockParam> getBlockParams() {
        ArrayList<XBBlockParam> resultList = new ArrayList<XBBlockParam>();
        XBCSpecService specService = this.catalog.getCatalogService(XBCSpecService.class);
        List<XBCSpecDef> specDefs = specService.getSpecDefs(this.blockSpec);
        for (XBCSpecDef specDef : specDefs) {
            resultList.add(this.convertParam(specDef));
        }
        return resultList;
    }

    @Override
    public long getParamsCount() {
        XBCSpecService specService = this.catalog.getCatalogService(XBCSpecService.class);
        return specService.findMaxSpecDefXB(this.blockSpec);
    }

    @Override
    public XBRevisionDef getRevisionDef() {
        return new XBCRevisionDef(this.catalog, this.blockSpec);
    }

    @Override
    public XBBlockParam getBlockParam(int paramIndex) {
        XBCSpecService specService = this.catalog.getCatalogService(XBCSpecService.class);
        XBCSpecDef specDef = specService.findSpecDefByXB(this.blockSpec, paramIndex);
        if (specDef == null) {
            return null;
        }
        return this.convertParam(specDef);
    }

    public XBBlockParam convertParam(@Nullable XBCSpecDef specDef) {
        if (specDef == null) {
            return null;
        }
        Optional<XBCRev> optionalTarget = specDef.getTargetRev();
        if (optionalTarget.isPresent()) {
            XBCRev target = optionalTarget.get();
            switch (specDef.getType()) {
                case CONSIST: {
                    return new XBBlockParamConsist(new XBCBlockDecl((XBCBlockRev)target, this.catalog));
                }
                case JOIN: {
                    return new XBBlockParamJoin(new XBCBlockDecl((XBCBlockRev)target, this.catalog));
                }
                case LIST_CONSIST: {
                    return new XBBlockParamListConsist(new XBCBlockDecl((XBCBlockRev)target, this.catalog));
                }
                case LIST_JOIN: {
                    return new XBBlockParamListJoin(new XBCBlockDecl((XBCBlockRev)target, this.catalog));
                }
            }
        } else {
            switch (specDef.getType()) {
                case CONSIST: {
                    return new XBBlockParamConsist();
                }
                case JOIN: {
                    return new XBBlockParamJoin();
                }
                case LIST_CONSIST: {
                    return new XBBlockParamListConsist();
                }
                case LIST_JOIN: {
                    return new XBBlockParamListJoin();
                }
            }
        }
        throw new IllegalStateException("Unexpected specification definition type");
    }

    @Override
    public void serializeXB(XBPSequenceSerialHandler serial) throws XBProcessingException, IOException {
        serial.begin();
        serial.matchType(new XBFixedBlockType(XBBasicBlockType.BLOCK_DEFINITION));
        serial.join(new XBCRevisionDef(this.catalog, this.blockSpec));
        serial.listConsist(new XBListConsistSerializable(){
            private int position = 0;

            @Override
            public UBENatural getSize() {
                XBCSpecService specService = XBCBlockDef.this.catalog.getCatalogService(XBCSpecService.class);
                Long maxSpecDefXB = specService.findMaxSpecDefXB(XBCBlockDef.this.blockSpec);
                return new UBENat32(maxSpecDefXB == null ? 0L : maxSpecDefXB);
            }

            @Override
            public void setSize(UBENatural count) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void reset() {
                this.position = 0;
            }

            @Override
            public XBSerializable next() {
                return new XBPSerializable(){

                    @Override
                    public void serializeFromXB(XBPInputSerialHandler serializationHandler) throws XBProcessingException, IOException {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }

                    @Override
                    public void serializeToXB(XBPOutputSerialHandler serializationHandler) throws XBProcessingException, IOException {
                        XBBlockParam param = XBCBlockDef.this.getBlockParam(position);
                        if (param == null) {
                            Logger.getLogger(XBCBlockDef.class.getName()).log(Level.SEVERE, "Block parameter is null");
                            serializationHandler.append(new XBBlockParamConsist(new XBCBlockDecl(null, XBCBlockDef.this.catalog)));
                        } else if (param instanceof XBBlockParamConsist) {
                            serializationHandler.append((XBBlockParamConsist)param);
                        } else if (param instanceof XBBlockParamJoin) {
                            serializationHandler.append((XBBlockParamJoin)param);
                        } else if (param instanceof XBBlockParamListConsist) {
                            serializationHandler.append((XBBlockParamListConsist)param);
                        } else if (param instanceof XBBlockParamListJoin) {
                            serializationHandler.append((XBBlockParamListJoin)param);
                        } else {
                            throw new IllegalStateException("Illegal block parameter " + position + ": " + (param == null ? "null" : param.getClass().getCanonicalName()));
                        }
                    }
                };
            }
        });
        serial.end();
    }
}

