/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.block.declaration.local;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.exbin.xbup.core.block.XBBasicBlockType;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.declaration.XBFormatDecl;
import org.exbin.xbup.core.block.declaration.XBGroupDecl;
import org.exbin.xbup.core.block.definition.XBFormatDef;
import org.exbin.xbup.core.block.definition.XBFormatParam;
import org.exbin.xbup.core.block.definition.XBFormatParamConsist;
import org.exbin.xbup.core.block.definition.XBFormatParamJoin;
import org.exbin.xbup.core.block.definition.local.XBLFormatDef;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBTListener;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.serial.basic.XBReceivingFinished;
import org.exbin.xbup.core.serial.basic.XBTBasicInputReceivingSerialHandler;
import org.exbin.xbup.core.serial.basic.XBTBasicOutputReceivingSerialHandler;
import org.exbin.xbup.core.serial.basic.XBTBasicReceivingSerializable;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBSerializationMode;

public class XBLFormatDecl
implements XBFormatDecl,
XBPSequenceSerializable,
XBTBasicReceivingSerializable {
    private long[] catalogPath = null;
    private int revision = 0;
    private XBFormatDef formatDef = null;

    public XBLFormatDecl() {
        this.catalogPath = null;
        this.revision = 0;
    }

    public XBLFormatDecl(long[] revisionPath) {
        this.revision = (int)revisionPath[revisionPath.length - 1];
        this.catalogPath = Arrays.copyOf(revisionPath, revisionPath.length - 1);
    }

    public XBLFormatDecl(Long[] revisionPath) {
        this.setCatalogObjectPath(Arrays.copyOf(revisionPath, revisionPath.length - 1));
        this.revision = revisionPath[revisionPath.length - 1].intValue();
    }

    public XBLFormatDecl(long[] specPath, int revision) {
        this.catalogPath = specPath;
        this.revision = revision;
    }

    public XBLFormatDecl(Long[] specPath, int revision) {
        this.setCatalogObjectPath(specPath);
        this.revision = revision;
    }

    public XBLFormatDecl(XBFormatDef formatDef) {
        this.formatDef = formatDef;
    }

    public XBLFormatDecl(XBGroupDecl groupDecl) {
        this.formatDef = new XBLFormatDef(groupDecl);
    }

    public XBLFormatDecl(long[] revisionPath, XBFormatDef formatDef) {
        this(revisionPath);
        this.formatDef = formatDef;
    }

    @Override
    public List<XBGroupDecl> getGroupDecls() {
        ArrayList<XBGroupDecl> groups = new ArrayList<XBGroupDecl>();
        int groupsLimit = this.getGroupsLimit();
        for (int paramIndex = 0; paramIndex < groupsLimit; ++paramIndex) {
            XBFormatParam formatParam = this.formatDef.getFormatParam(paramIndex);
            if (formatParam instanceof XBFormatParamJoin) {
                XBFormatDecl groupDecl = ((XBFormatParamJoin)formatParam).getFormatDecl();
                groups.addAll(groupDecl.getGroupDecls());
                continue;
            }
            if (formatParam == null) continue;
            groups.add(((XBFormatParamConsist)formatParam).getGroupDecl());
        }
        return groups;
    }

    public int getGroupsLimit() {
        return this.formatDef == null ? 0 : (this.formatDef.getRevisionDef() == null ? 0 : this.formatDef.getRevisionDef().getRevisionLimit(this.revision));
    }

    private void setCatalogObjectPath(Long[] path) {
        this.catalogPath = new long[path.length];
        for (int i = 0; i < path.length; ++i) {
            this.catalogPath[i] = path[i];
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Arrays.hashCode(this.catalogPath);
        hash = 47 * hash + this.revision;
        return hash;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof XBLFormatDecl) {
            return Arrays.equals(((XBLFormatDecl)obj).catalogPath, this.catalogPath) && ((XBLFormatDecl)obj).revision == this.revision;
        }
        if (obj instanceof XBFormatDecl) {
            obj.equals(this);
        }
        return super.equals(obj);
    }

    public void clear() {
        this.catalogPath = null;
        this.revision = 0;
        this.formatDef = null;
    }

    @Override
    public void serializeXB(XBPSequenceSerialHandler serial) throws XBProcessingException, IOException {
        serial.begin();
        serial.matchType(new XBFixedBlockType(XBBasicBlockType.FORMAT_DECLARATION));
        if (serial.getSerializationMode() == XBSerializationMode.PULL) {
            this.catalogPath = new long[serial.pullAttribute().getNaturalInt()];
            for (int pathPosition = 0; pathPosition < this.catalogPath.length; ++pathPosition) {
                this.catalogPath[pathPosition] = serial.pullLongAttribute();
            }
            this.revision = serial.pullAttribute().getNaturalInt();
            if (!serial.pullIfEmptyBlock()) {
                this.formatDef = new XBLFormatDef();
                serial.pullConsist(this.formatDef);
            } else {
                this.formatDef = null;
            }
        } else {
            if (this.catalogPath != null) {
                serial.putAttribute(this.catalogPath.length);
                for (long pathIndex : this.catalogPath) {
                    serial.putAttribute(pathIndex);
                }
            } else {
                serial.putAttribute(0);
            }
            serial.putAttribute(this.revision);
            if (this.formatDef != null) {
                serial.putConsist(this.formatDef);
            }
        }
        serial.end();
    }

    @Override
    public void serializeRecvFromXB(XBTBasicInputReceivingSerialHandler serializationHandler) throws XBProcessingException, IOException {
        this.clear();
        serializationHandler.process(new RecvSerialization());
    }

    @Override
    public void serializeRecvToXB(XBTBasicOutputReceivingSerialHandler serializationHandler) throws XBProcessingException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long[] getCatalogPath() {
        return this.catalogPath;
    }

    public Long[] getCatalogPathAsClassArray() {
        if (this.catalogPath == null) {
            return null;
        }
        Long[] classCatalogPath = new Long[this.catalogPath.length];
        for (int pathIndex = 0; pathIndex < this.catalogPath.length; ++pathIndex) {
            classCatalogPath[pathIndex] = this.catalogPath[pathIndex];
        }
        return classCatalogPath;
    }

    public void setCatalogPath(long[] catalogPath) {
        this.catalogPath = catalogPath;
    }

    public void setCatalogPath(Long[] path) {
        this.setCatalogObjectPath(path);
    }

    @Override
    public XBFormatDef getFormatDef() {
        return this.formatDef;
    }

    public void setFormatDef(XBFormatDef formatDef) {
        this.formatDef = formatDef;
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    static /* synthetic */ long[] access$302(XBLFormatDecl x0, long[] x1) {
        x0.catalogPath = x1;
        return x1;
    }

    private class RecvSerialization
    implements XBTListener,
    XBReceivingFinished {
        private RecvProcessingState processingState = RecvProcessingState.START;
        private XBTListener activeListener = null;
        private int catalogPathPos = 0;

        private RecvSerialization() {
        }

        @Override
        public void beginXBT(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
            if (this.processingState == RecvProcessingState.TYPE || this.processingState == RecvProcessingState.CATALOG_PATH || this.processingState == RecvProcessingState.CATALOG_PATH_SIZE || this.processingState == RecvProcessingState.REVISION) {
                this.finishCatalogPath();
                XBLFormatDecl.this.formatDef = new XBLFormatDef();
                ((XBLFormatDef)XBLFormatDecl.this.formatDef).serializeRecvFromXB(new XBTBasicInputReceivingSerialHandler(){

                    @Override
                    public void process(XBTListener listener) {
                        RecvSerialization.this.activeListener = listener;
                    }
                });
            }
            if (this.activeListener != null) {
                this.activeListener.beginXBT(terminationMode);
                return;
            }
            if (this.processingState != RecvProcessingState.START) {
                throw new XBProcessingException("Unexpected token: begin", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
            this.processingState = RecvProcessingState.BEGIN;
        }

        @Override
        public void typeXBT(XBBlockType type) throws XBProcessingException, IOException {
            if (this.activeListener != null) {
                this.activeListener.typeXBT(type);
                return;
            }
            if (this.processingState != RecvProcessingState.BEGIN) {
                throw new XBProcessingException("Unexpected token: type", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
            this.processingState = RecvProcessingState.TYPE;
        }

        @Override
        public void attribXBT(XBAttribute value) throws XBProcessingException, IOException {
            if (this.activeListener != null) {
                this.activeListener.attribXBT(value);
                return;
            }
            if (this.processingState == RecvProcessingState.TYPE) {
                XBLFormatDecl.access$302(XBLFormatDecl.this, new long[value.getNaturalInt()]);
                this.catalogPathPos = 0;
                this.processingState = RecvProcessingState.CATALOG_PATH_SIZE;
            } else if (this.processingState == RecvProcessingState.CATALOG_PATH_SIZE) {
                ((XBLFormatDecl)XBLFormatDecl.this).catalogPath[this.catalogPathPos] = value.getNaturalLong();
                ++this.catalogPathPos;
                if (this.catalogPathPos == XBLFormatDecl.this.catalogPath.length) {
                    this.processingState = RecvProcessingState.CATALOG_PATH;
                }
            } else if (this.processingState == RecvProcessingState.CATALOG_PATH) {
                XBLFormatDecl.this.revision = value.getNaturalInt();
                this.processingState = RecvProcessingState.REVISION;
            } else if (this.processingState != RecvProcessingState.REVISION) {
                throw new XBProcessingException("Unexpected token: attribute", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
        }

        @Override
        public void dataXBT(InputStream data) throws XBProcessingException, IOException {
            if (this.activeListener != null) {
                this.activeListener.dataXBT(data);
                return;
            }
            throw new XBProcessingException("Unexpected token: data", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }

        @Override
        public void endXBT() throws XBProcessingException, IOException {
            if (this.activeListener != null) {
                this.activeListener.endXBT();
                if (((XBReceivingFinished)((Object)this.activeListener)).isFinished()) {
                    this.processingState = RecvProcessingState.FORMAT_DEFINITION;
                    this.activeListener = null;
                }
                return;
            }
            if (this.processingState == RecvProcessingState.START || this.processingState == RecvProcessingState.BEGIN || this.processingState == RecvProcessingState.END) {
                throw new XBProcessingException("Unexpected token: end", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
            this.finishCatalogPath();
            this.processingState = RecvProcessingState.END;
        }

        private void finishCatalogPath() {
            if (this.processingState == RecvProcessingState.CATALOG_PATH_SIZE) {
                for (int i = this.catalogPathPos; i < XBLFormatDecl.this.catalogPath.length; ++i) {
                    ((XBLFormatDecl)XBLFormatDecl.this).catalogPath[i] = 0L;
                }
            }
        }

        @Override
        public boolean isFinished() {
            return this.processingState == RecvProcessingState.END;
        }
    }

    private static enum RecvProcessingState {
        START,
        BEGIN,
        TYPE,
        CATALOG_PATH_SIZE,
        CATALOG_PATH,
        REVISION,
        FORMAT_DEFINITION,
        END;

    }
}

