/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.block.declaration.local;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.exbin.xbup.core.block.XBBasicBlockType;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.definition.XBBlockDef;
import org.exbin.xbup.core.block.definition.local.XBLBlockDef;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBTListener;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.serial.basic.XBReceivingFinished;
import org.exbin.xbup.core.serial.basic.XBTBasicInputReceivingSerialHandler;
import org.exbin.xbup.core.serial.basic.XBTBasicOutputReceivingSerialHandler;
import org.exbin.xbup.core.serial.basic.XBTBasicReceivingSerializable;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBSerializationMode;

public class XBLBlockDecl
implements XBBlockDecl,
XBPSequenceSerializable,
XBTBasicReceivingSerializable {
    private long[] catalogPath = null;
    private int revision = 0;
    private XBBlockDef blockDef = null;

    public XBLBlockDecl() {
        this.catalogPath = null;
        this.revision = 0;
    }

    public XBLBlockDecl(long[] revisionPath) {
        this.revision = (int)revisionPath[revisionPath.length - 1];
        this.catalogPath = Arrays.copyOf(revisionPath, revisionPath.length - 1);
    }

    public XBLBlockDecl(Long[] revisionPath) {
        this.setCatalogObjectPath(Arrays.copyOf(revisionPath, revisionPath.length - 1));
        this.revision = revisionPath[revisionPath.length - 1].intValue();
    }

    public XBLBlockDecl(long[] specPath, int revision) {
        this.catalogPath = specPath;
        this.revision = revision;
    }

    public XBLBlockDecl(Long[] specPath, int revision) {
        this.setCatalogObjectPath(specPath);
        this.revision = revision;
    }

    private void setCatalogObjectPath(Long[] path) {
        this.catalogPath = new long[path.length];
        for (int i = 0; i < path.length; ++i) {
            this.catalogPath[i] = path[i];
        }
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof XBLBlockDecl) {
            return Arrays.equals(((XBLBlockDecl)obj).catalogPath, this.catalogPath) && ((XBLBlockDecl)obj).revision == this.revision;
        }
        if (obj instanceof XBBlockDecl) {
            return obj.equals(this);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Arrays.hashCode(this.catalogPath);
        hash = 47 * hash + this.revision;
        return hash;
    }

    public void clear() {
        this.catalogPath = null;
        this.revision = 0;
        this.blockDef = null;
    }

    @Override
    public void serializeRecvToXB(XBTBasicOutputReceivingSerialHandler serializationHandler) throws XBProcessingException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public XBCBlockSpec getBlockSpec(XBCatalog catalog) {
        return (XBCBlockSpec)((Object)catalog.findBlockTypeByPath(this.getCatalogObjectPath(), this.revision));
    }

    public Long[] getCatalogObjectPath() {
        Long[] objectPath = new Long[this.catalogPath.length];
        for (int i = 0; i < objectPath.length; ++i) {
            objectPath[i] = this.catalogPath[i];
        }
        return objectPath;
    }

    public long[] getCatalogPath() {
        return this.catalogPath;
    }

    public void setCatalogPath(long[] catalogPath) {
        this.catalogPath = catalogPath;
    }

    public void setCatalogPath(Long[] path) {
        this.setCatalogObjectPath(path);
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    @Override
    public XBBlockDef getBlockDef() {
        return this.blockDef;
    }

    public void setBlockDef(XBBlockDef blockDef) {
        this.blockDef = blockDef;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public void serializeXB(XBPSequenceSerialHandler serial) throws XBProcessingException, IOException {
        serial.begin();
        serial.matchType(new XBFixedBlockType(XBBasicBlockType.BLOCK_DECLARATION));
        if (serial.getSerializationMode() == XBSerializationMode.PULL) {
            this.catalogPath = new long[serial.pullAttribute().getNaturalInt()];
            for (int pathPosition = 0; pathPosition < this.catalogPath.length; ++pathPosition) {
                this.catalogPath[pathPosition] = serial.pullLongAttribute();
            }
            this.revision = serial.pullAttribute().getNaturalInt();
            if (!serial.pullIfEmptyBlock()) {
                this.blockDef = new XBLBlockDef();
                serial.pullConsist(this.blockDef);
            }
        } else {
            if (this.catalogPath != null) {
                serial.putAttribute(this.catalogPath.length);
                for (long pathIndex : this.catalogPath) {
                    serial.putAttribute(pathIndex);
                }
            } else {
                serial.putAttribute(0);
            }
            serial.putAttribute(this.revision);
            if (this.blockDef != null) {
                serial.putConsist(this.blockDef);
            }
        }
        serial.end();
    }

    @Override
    public void serializeRecvFromXB(XBTBasicInputReceivingSerialHandler serializationHandler) throws XBProcessingException, IOException {
        this.clear();
        serializationHandler.process(new RecvSerialization());
    }

    static /* synthetic */ long[] access$302(XBLBlockDecl x0, long[] x1) {
        x0.catalogPath = x1;
        return x1;
    }

    private class RecvSerialization
    implements XBTListener,
    XBReceivingFinished {
        private RecvProcessingState processingState = RecvProcessingState.START;
        private XBTListener activeListener = null;
        private int catalogPathPos = 0;

        private RecvSerialization() {
        }

        @Override
        public void beginXBT(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
            if (this.processingState == RecvProcessingState.TYPE || this.processingState == RecvProcessingState.CATALOG_PATH || this.processingState == RecvProcessingState.CATALOG_PATH_SIZE || this.processingState == RecvProcessingState.REVISION) {
                this.finishCatalogPath();
                XBLBlockDecl.this.blockDef = new XBLBlockDef();
                ((XBLBlockDef)XBLBlockDecl.this.blockDef).serializeRecvFromXB(new XBTBasicInputReceivingSerialHandler(){

                    @Override
                    public void process(XBTListener listener) {
                        RecvSerialization.this.activeListener = listener;
                    }
                });
            }
            if (this.activeListener != null) {
                this.activeListener.beginXBT(terminationMode);
                return;
            }
            if (this.processingState != RecvProcessingState.START) {
                throw new XBProcessingException("Unexpected token: begin", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
            this.processingState = RecvProcessingState.BEGIN;
        }

        @Override
        public void typeXBT(XBBlockType type) throws XBProcessingException, IOException {
            if (this.activeListener != null) {
                this.activeListener.typeXBT(type);
                return;
            }
            if (this.processingState != RecvProcessingState.BEGIN) {
                throw new XBProcessingException("Unexpected token: type", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
            this.processingState = RecvProcessingState.TYPE;
        }

        @Override
        public void attribXBT(XBAttribute value) throws XBProcessingException, IOException {
            if (this.activeListener != null) {
                this.activeListener.attribXBT(value);
                return;
            }
            if (this.processingState == RecvProcessingState.TYPE) {
                XBLBlockDecl.access$302(XBLBlockDecl.this, new long[value.getNaturalInt()]);
                this.catalogPathPos = 0;
                this.processingState = RecvProcessingState.CATALOG_PATH_SIZE;
            } else if (this.processingState == RecvProcessingState.CATALOG_PATH_SIZE) {
                ((XBLBlockDecl)XBLBlockDecl.this).catalogPath[this.catalogPathPos] = value.getNaturalLong();
                ++this.catalogPathPos;
                if (this.catalogPathPos == XBLBlockDecl.this.catalogPath.length) {
                    this.processingState = RecvProcessingState.CATALOG_PATH;
                }
            } else if (this.processingState == RecvProcessingState.CATALOG_PATH) {
                XBLBlockDecl.this.revision = value.getNaturalInt();
                this.processingState = RecvProcessingState.REVISION;
            } else {
                throw new XBProcessingException("Unexpected token: attribute", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
        }

        @Override
        public void dataXBT(InputStream data) throws XBProcessingException, IOException {
            if (this.activeListener != null) {
                this.activeListener.dataXBT(data);
                return;
            }
            throw new XBProcessingException("Unexpected token: data", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }

        @Override
        public void endXBT() throws XBProcessingException, IOException {
            if (this.activeListener != null) {
                this.activeListener.endXBT();
                if (((XBReceivingFinished)((Object)this.activeListener)).isFinished()) {
                    this.processingState = RecvProcessingState.BLOCK_DEFINITION;
                    this.activeListener = null;
                }
                return;
            }
            if (this.processingState == RecvProcessingState.START || this.processingState == RecvProcessingState.BEGIN || this.processingState == RecvProcessingState.END) {
                throw new XBProcessingException("Unexpected token: end", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
            this.finishCatalogPath();
            this.processingState = RecvProcessingState.END;
        }

        private void finishCatalogPath() {
            if (this.processingState == RecvProcessingState.CATALOG_PATH_SIZE) {
                for (int i = this.catalogPathPos; i < XBLBlockDecl.this.catalogPath.length; ++i) {
                    ((XBLBlockDecl)XBLBlockDecl.this).catalogPath[i] = 0L;
                }
            }
        }

        @Override
        public boolean isFinished() {
            return this.processingState == RecvProcessingState.END;
        }
    }

    private static enum RecvProcessingState {
        START,
        BEGIN,
        TYPE,
        CATALOG_PATH_SIZE,
        CATALOG_PATH,
        REVISION,
        BLOCK_DEFINITION,
        END;

    }
}

