/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.block.declaration.catalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.exbin.xbup.core.block.XBBasicBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.declaration.XBFormatDecl;
import org.exbin.xbup.core.block.declaration.XBGroupDecl;
import org.exbin.xbup.core.block.declaration.local.XBLFormatDecl;
import org.exbin.xbup.core.block.definition.XBFormatDef;
import org.exbin.xbup.core.block.definition.catalog.XBCFormatDef;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.XBPCatalog;
import org.exbin.xbup.core.catalog.base.XBCFormatRev;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBSerializationMode;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

public class XBCFormatDecl
implements XBFormatDecl,
XBPSequenceSerializable {
    private XBCFormatRev formatSpecRev;
    private final XBCatalog catalog;

    public XBCFormatDecl() {
        this(null, new XBPCatalog());
    }

    public XBCFormatDecl(XBCFormatRev formatSpecRev, XBCatalog catalog) {
        this.formatSpecRev = formatSpecRev;
        this.catalog = catalog;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof XBCFormatDecl) {
            XBCFormatDecl other = (XBCFormatDecl)obj;
            if (this.formatSpecRev == null || !this.formatSpecRev.equals(other.formatSpecRev)) {
                return false;
            }
            return this.formatSpecRev.getId() == other.formatSpecRev.getId();
        }
        if (obj instanceof XBLFormatDecl) {
            Long[] catalogPath = this.catalog.getSpecPath(this.formatSpecRev.getParent());
            long[] objCatalogPath = ((XBLFormatDecl)obj).getCatalogPath();
            if (objCatalogPath.length != catalogPath.length) {
                return false;
            }
            for (int pathIndex = 0; pathIndex < catalogPath.length; ++pathIndex) {
                if (catalogPath[pathIndex] == objCatalogPath[pathIndex]) continue;
                return false;
            }
            return this.formatSpecRev.getXBIndex() == ((XBLFormatDecl)obj).getRevision();
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.formatSpecRev != null ? this.formatSpecRev.hashCode() : 0);
        return hash;
    }

    @Override
    public void serializeXB(XBPSequenceSerialHandler serializationHandler) throws XBProcessingException, IOException {
        serializationHandler.begin();
        serializationHandler.matchType(new XBFixedBlockType(XBBasicBlockType.FORMAT_DECLARATION));
        if (serializationHandler.getSerializationMode() == XBSerializationMode.PULL) {
            Long[] catalogPath = new Long[serializationHandler.pullIntAttribute()];
            for (int pathPosition = 0; pathPosition < catalogPath.length; ++pathPosition) {
                catalogPath[pathPosition] = serializationHandler.pullLongAttribute();
            }
            long revision = serializationHandler.pullLongAttribute();
            XBCFormatDecl format = (XBCFormatDecl)this.catalog.findFormatTypeByPath(catalogPath, (int)revision);
            this.formatSpecRev = format == null ? null : format.getFormatSpecRev();
        } else {
            Long[] path = this.catalog.getSpecPath(this.formatSpecRev.getParent());
            serializationHandler.putAttribute(path.length - 1);
            for (Long pathIndex : path) {
                serializationHandler.putAttribute(pathIndex);
            }
            serializationHandler.putAttribute(new UBNat32(this.formatSpecRev.getXBIndex()));
        }
        serializationHandler.end();
    }

    @Override
    public List<XBGroupDecl> getGroupDecls() {
        return this.formatSpecRev == null ? new ArrayList<XBGroupDecl>() : this.catalog.getGroups(this.formatSpecRev.getParent());
    }

    public XBCFormatRev getFormatSpecRev() {
        return this.formatSpecRev;
    }

    public void setFormatSpecRev(XBCFormatRev formatSpecRev) {
        this.formatSpecRev = formatSpecRev;
    }

    @Override
    public XBFormatDef getFormatDef() {
        return new XBCFormatDef(this.catalog, this.formatSpecRev.getParent());
    }

    @Override
    public long getRevision() {
        return this.formatSpecRev.getXBIndex();
    }
}

