/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.block;

import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBEditableBlock;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.XBTEditableBlock;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.type.XBData;

public class XBTDefaultBlock
implements XBTBlock {
    @Nullable
    private XBTBlock parent;
    @Nonnull
    private final XBBlockDataMode dataMode;
    @Nonnull
    private final XBBlockTerminationMode terminationMode;
    @Nullable
    private final XBBlockType blockType;
    @Nullable
    private final XBAttribute[] attributes;
    @Nullable
    private final XBTBlock[] children;
    @Nullable
    private final BinaryData data;

    public XBTDefaultBlock() {
        this(null, XBBlockTerminationMode.SIZE_SPECIFIED, (BinaryData)new XBData());
    }

    public XBTDefaultBlock(@Nullable XBTBlock parent, @Nullable XBBlockTerminationMode terminationMode, @Nullable BinaryData data) {
        this.dataMode = XBBlockDataMode.DATA_BLOCK;
        this.parent = parent;
        this.terminationMode = terminationMode == null ? XBBlockTerminationMode.SIZE_SPECIFIED : terminationMode;
        this.blockType = null;
        this.attributes = null;
        this.children = null;
        this.data = data == null ? new XBData() : data;
    }

    public XBTDefaultBlock(@Nullable XBBlockTerminationMode terminationMode, @Nullable BinaryData data) {
        this(null, terminationMode, data);
    }

    public XBTDefaultBlock(@Nullable XBTBlock parent, @Nullable XBBlockTerminationMode terminationMode, @Nullable XBBlockType blockType, @Nullable XBAttribute[] attributes, @Nullable XBTBlock[] children) {
        this.dataMode = XBBlockDataMode.NODE_BLOCK;
        this.parent = parent;
        this.terminationMode = terminationMode == null ? XBBlockTerminationMode.SIZE_SPECIFIED : terminationMode;
        this.blockType = blockType == null ? XBFixedBlockType.UNKNOWN_BLOCK_TYPE : blockType;
        this.attributes = attributes == null ? new XBAttribute[]{} : attributes;
        this.children = children == null ? new XBTBlock[]{} : children;
        this.data = null;
        if (children != null) {
            this.attachChildren(children);
        }
    }

    public XBTDefaultBlock(@Nullable XBBlockTerminationMode terminationMode, @Nullable XBBlockType blockType, @Nullable XBAttribute[] attributes, @Nullable XBTBlock[] children) {
        this(null, terminationMode, blockType, attributes, children);
    }

    private void attachChildren(@Nonnull XBTBlock[] children) {
        for (XBTBlock child : children) {
            if (child instanceof XBTDefaultBlock) {
                ((XBTDefaultBlock)child).setParent(this);
                continue;
            }
            if (!(child instanceof XBEditableBlock)) continue;
            ((XBTEditableBlock)child).setParent(this);
        }
    }

    @Override
    @Nonnull
    public Optional<XBTBlock> getParentBlock() {
        return Optional.ofNullable(this.parent);
    }

    public void setParent(@Nullable XBTBlock parent) {
        this.parent = parent;
    }

    @Override
    @Nonnull
    public XBBlockDataMode getDataMode() {
        return this.dataMode;
    }

    @Override
    @Nonnull
    public XBBlockTerminationMode getTerminationMode() {
        return this.terminationMode;
    }

    @Override
    @Nonnull
    public XBBlockType getBlockType() {
        return this.blockType;
    }

    @Override
    @Nullable
    public XBAttribute[] getAttributes() {
        return this.attributes;
    }

    @Override
    @Nullable
    public XBAttribute getAttributeAt(int attributeIndex) {
        return this.attributes[attributeIndex];
    }

    @Override
    public int getAttributesCount() {
        return this.attributes.length;
    }

    @Override
    @Nullable
    public XBTBlock[] getChildren() {
        return this.children;
    }

    @Override
    @Nullable
    public XBTBlock getChildAt(int childIndex) {
        return this.children[childIndex];
    }

    @Override
    public int getChildrenCount() {
        return this.children.length;
    }

    @Override
    @Nonnull
    public InputStream getData() {
        if (this.dataMode != XBBlockDataMode.DATA_BLOCK) {
            throw new IllegalStateException("Cannot read data of node block");
        }
        return this.data.getDataInputStream();
    }

    @Override
    @Nonnull
    public BinaryData getBlockData() {
        if (this.dataMode != XBBlockDataMode.DATA_BLOCK) {
            throw new IllegalStateException("Cannot read data of node block");
        }
        return Objects.requireNonNull(this.data);
    }

    public static int getBlockIndex(@Nullable XBTBlock block) {
        if (block == null) {
            return -1;
        }
        Optional<XBTBlock> blockParent = block.getParentBlock();
        if (blockParent.isPresent()) {
            XBTBlock child;
            int result = XBTDefaultBlock.getBlockIndex(blockParent.get()) + 1;
            int childIndex = 0;
            do {
                if (block.equals(child = blockParent.get().getChildAt(childIndex))) {
                    return result + childIndex;
                }
                ++childIndex;
            } while (child != null);
            return -1;
        }
        return 0;
    }

    public static int getChildIndexOf(@Nullable XBTBlock parent, @Nullable XBTBlock block) {
        XBTBlock child;
        if (block == null || parent == null) {
            return -1;
        }
        int childIndex = 0;
        XBTBlock blockParent = block.getParentBlock().get();
        do {
            if (block.equals(child = blockParent.getChildAt(childIndex))) {
                return childIndex;
            }
            ++childIndex;
        } while (child != null);
        return -1;
    }
}

