/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave.service.impl;

import java.awt.Color;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.wave.gui.AudioPanel;
import org.exbin.framework.editor.wave.service.WaveColorService;
import org.exbin.framework.file.api.FileHandler;

@ParametersAreNonnullByDefault
public class WaveColorServiceImpl
implements WaveColorService {
    private final EditorProvider editorProvider;

    public WaveColorServiceImpl(EditorProvider editorProvider) {
        this.editorProvider = editorProvider;
    }

    @Override
    @Nonnull
    public Color[] getCurrentWaveColors() {
        Optional activeFile = this.editorProvider.getActiveFile();
        if (!activeFile.isPresent()) {
            throw new IllegalStateException();
        }
        AudioPanel audioPanel = (AudioPanel)((FileHandler)activeFile.get()).getComponent();
        return audioPanel.getAudioPanelColors();
    }

    @Override
    @Nonnull
    public Color[] getDefaultWaveColors() {
        Optional activeFile = this.editorProvider.getActiveFile();
        if (!activeFile.isPresent()) {
            throw new IllegalStateException();
        }
        AudioPanel audioPanel = (AudioPanel)((FileHandler)activeFile.get()).getComponent();
        return audioPanel.getDefaultColors();
    }

    @Override
    public void setCurrentWaveColors(Color[] colors) {
        Optional activeFile = this.editorProvider.getActiveFile();
        if (!activeFile.isPresent()) {
            throw new IllegalStateException();
        }
        AudioPanel audioPanel = (AudioPanel)((FileHandler)activeFile.get()).getComponent();
        audioPanel.setAudioPanelColors(colors);
    }
}

