/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave.preferences;

import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.editor.wave.options.WaveColorOptions;

@ParametersAreNonnullByDefault
public class WaveColorPreferences
implements WaveColorOptions {
    public static final String PREFERENCES_WAVE_COLOR_DEFAULT = "waveColor.default";
    public static final String PREFERENCES_WAVE_COLOR_WAVE = "waveColor.wave";
    public static final String PREFERENCES_WAVE_COLOR_WAVE_FILL = "waveColor.waveFill";
    public static final String PREFERENCES_WAVE_COLOR_BACKGROUND = "waveColor.background";
    public static final String PREFERENCES_WAVE_COLOR_SELECTION = "waveColor.selection";
    public static final String PREFERENCES_WAVE_COLOR_CURSOR = "waveColor.cursor";
    public static final String PREFERENCES_WAVE_COLOR_CURSOR_WAVE = "waveColor.cursorWave";
    private final Preferences preferences;

    public WaveColorPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public boolean isUseDefaultColors() {
        return this.preferences.getBoolean(PREFERENCES_WAVE_COLOR_DEFAULT, true);
    }

    @Override
    public void setUseDefaultColors(boolean useDefault) {
        this.preferences.putBoolean(PREFERENCES_WAVE_COLOR_DEFAULT, useDefault);
    }

    @Override
    @Nullable
    public Integer getWaveColor() {
        return this.getColorAsInt(PREFERENCES_WAVE_COLOR_WAVE);
    }

    @Override
    @Nullable
    public Integer getWaveFillColor() {
        return this.getColorAsInt(PREFERENCES_WAVE_COLOR_WAVE_FILL);
    }

    @Override
    @Nullable
    public Integer getWaveBackgroundColor() {
        return this.getColorAsInt(PREFERENCES_WAVE_COLOR_BACKGROUND);
    }

    @Override
    @Nullable
    public Integer getWaveSelectionColor() {
        return this.getColorAsInt(PREFERENCES_WAVE_COLOR_SELECTION);
    }

    @Override
    @Nullable
    public Integer getWaveCursorColor() {
        return this.getColorAsInt(PREFERENCES_WAVE_COLOR_CURSOR);
    }

    @Override
    @Nullable
    public Integer getWaveCursorWaveColor() {
        return this.getColorAsInt(PREFERENCES_WAVE_COLOR_CURSOR_WAVE);
    }

    @Nullable
    private Integer getColorAsInt(String key) {
        Optional value = this.preferences.get(key);
        return value.isPresent() ? Integer.valueOf((String)value.get()) : null;
    }

    @Override
    public void setWaveColor(@Nullable Integer color) {
        this.setColor(PREFERENCES_WAVE_COLOR_WAVE, color);
    }

    public void setWaveColor(int color) {
        this.preferences.putInt(PREFERENCES_WAVE_COLOR_WAVE, color);
    }

    @Override
    public void setWaveFillColor(@Nullable Integer color) {
        this.setColor(PREFERENCES_WAVE_COLOR_WAVE_FILL, color);
    }

    public void setWaveFillColor(int color) {
        this.preferences.putInt(PREFERENCES_WAVE_COLOR_WAVE_FILL, color);
    }

    @Override
    public void setWaveBackgroundColor(@Nullable Integer color) {
        this.setColor(PREFERENCES_WAVE_COLOR_BACKGROUND, color);
    }

    public void setWaveBackgroundColor(int color) {
        this.preferences.putInt(PREFERENCES_WAVE_COLOR_BACKGROUND, color);
    }

    @Override
    public void setWaveSelectionColor(@Nullable Integer color) {
        this.setColor(PREFERENCES_WAVE_COLOR_SELECTION, color);
    }

    public void setWaveSelectionColor(int color) {
        this.preferences.putInt(PREFERENCES_WAVE_COLOR_SELECTION, color);
    }

    @Override
    public void setWaveCursorColor(@Nullable Integer color) {
        this.setColor(PREFERENCES_WAVE_COLOR_CURSOR, color);
    }

    public void setWaveCursorColor(int color) {
        this.preferences.putInt(PREFERENCES_WAVE_COLOR_CURSOR, color);
    }

    @Override
    public void setWaveCursorWaveColor(@Nullable Integer color) {
        this.setColor(PREFERENCES_WAVE_COLOR_CURSOR_WAVE, color);
    }

    public void setWaveCursorWaveColor(int color) {
        this.preferences.putInt(PREFERENCES_WAVE_COLOR_CURSOR_WAVE, color);
    }

    private void setColor(String preferenceName, @Nullable Integer color) {
        if (color == null) {
            this.preferences.remove(preferenceName);
        } else {
            this.preferences.putInt(preferenceName, color.intValue());
        }
    }
}

