/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave.options.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.exbin.framework.editor.wave.options.impl.WaveColorOptionsImpl;
import org.exbin.framework.editor.wave.service.WaveColorService;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class WaveColorPanel
extends JPanel
implements OptionsComponent<WaveColorOptionsImpl> {
    private OptionsModifiedListener optionsModifiedListener;
    private WaveColorService waveColorService;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(WaveColorPanel.class);
    private JColorChooser colorChooser;
    private JButton fillCurrentButton;
    private JButton fillDefaultButton;
    private JButton waveBackgroundColorButton;
    private JLabel waveBackgroundColorLabel;
    private JPanel waveBackgroundColorPanel;
    private JButton waveColorButton;
    private JLabel waveColorLabel;
    private JPanel waveColorPanel;
    private JButton waveCursorColorButton;
    private JLabel waveCursorColorLabel;
    private JPanel waveCursorColorPanel;
    private JButton waveCursorWaveColorButton;
    private JLabel waveCursorWaveColorLabel;
    private JPanel waveCursorWaveColorPanel;
    private JButton waveFillColorButton;
    private JLabel waveFillColorLabel;
    private JPanel waveFillColorPanel;
    private JButton waveSelectionColorButton;
    private JLabel waveSelectionColorLabel;
    private JPanel waveSelectionColorPanel;

    public WaveColorPanel() {
        this.initComponents();
    }

    public void setWaveColorService(WaveColorService waveColorService) {
        this.waveColorService = waveColorService;
        this.fillCurrentButton.setEnabled(true);
        this.fillDefaultButton.setEnabled(true);
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void loadFromOptions(WaveColorOptionsImpl options) {
        Integer rgb;
        try {
            rgb = options.getWaveColor();
            if (rgb != null) {
                this.setWaveColor(new Color(rgb));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            rgb = options.getWaveBackgroundColor();
            if (rgb != null) {
                this.setWaveBackgroundColor(new Color(rgb));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            rgb = options.getWaveSelectionColor();
            if (rgb != null) {
                this.setWaveSelectionColor(new Color(rgb));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            rgb = options.getWaveCursorColor();
            if (rgb != null) {
                this.setWaveCursorColor(new Color(rgb));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void saveToOptions(WaveColorOptionsImpl options) {
        options.setWaveColor(this.getWaveColor().getRGB());
        options.setWaveFillColor(this.getWaveFillColor().getRGB());
        options.setWaveBackgroundColor(this.getWaveBackgroundColor().getRGB());
        options.setWaveSelectionColor(this.getWaveSelectionColor().getRGB());
        options.setWaveCursorColor(this.getWaveCursorColor().getRGB());
        options.setWaveCursorWaveColor(this.getWaveCursorWaveColor().getRGB());
    }

    @Nonnull
    public Color getWaveColor() {
        return this.waveColorPanel.getBackground();
    }

    @Nonnull
    public Color getWaveFillColor() {
        return this.waveFillColorPanel.getBackground();
    }

    @Nonnull
    public Color getWaveBackgroundColor() {
        return this.waveBackgroundColorPanel.getBackground();
    }

    @Nonnull
    public Color getWaveSelectionColor() {
        return this.waveSelectionColorPanel.getBackground();
    }

    @Nonnull
    public Color getWaveCursorColor() {
        return this.waveCursorColorPanel.getBackground();
    }

    @Nonnull
    public Color getWaveCursorWaveColor() {
        return this.waveCursorWaveColorPanel.getBackground();
    }

    public void setDefaultAudioPanelColors() {
        this.setWaveColorsFromArray(this.waveColorService.getDefaultWaveColors());
    }

    public void setWaveColor(Color color) {
        this.waveColorPanel.setBackground(color);
    }

    public void setWaveFillColor(Color color) {
        this.waveFillColorPanel.setBackground(color);
    }

    public void setWaveBackgroundColor(Color color) {
        this.waveBackgroundColorPanel.setBackground(color);
    }

    public void setWaveSelectionColor(Color color) {
        this.waveSelectionColorPanel.setBackground(color);
    }

    public void setWaveCursorColor(Color color) {
        this.waveCursorColorPanel.setBackground(color);
    }

    public void setWaveCursorWaveColor(Color color) {
        this.waveCursorWaveColorPanel.setBackground(color);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.waveColorButton.setEnabled(enabled);
        this.waveFillColorButton.setEnabled(enabled);
        this.waveBackgroundColorButton.setEnabled(enabled);
        this.waveSelectionColorButton.setEnabled(enabled);
        this.waveCursorColorButton.setEnabled(enabled);
        this.waveCursorWaveColorButton.setEnabled(enabled);
        this.fillCurrentButton.setEnabled(enabled);
        this.fillDefaultButton.setEnabled(enabled);
        this.fillCurrentButton.setEnabled(enabled && this.waveColorService != null);
        this.fillDefaultButton.setEnabled(enabled && this.waveColorService != null);
    }

    private void initComponents() {
        this.colorChooser = new JColorChooser();
        this.waveSelectionColorButton = new JButton();
        this.waveColorLabel = new JLabel();
        this.waveColorPanel = new JPanel();
        this.waveColorButton = new JButton();
        this.waveSelectionColorLabel = new JLabel();
        this.waveBackgroundColorLabel = new JLabel();
        this.waveCursorColorLabel = new JLabel();
        this.fillDefaultButton = new JButton();
        this.fillCurrentButton = new JButton();
        this.waveCursorColorPanel = new JPanel();
        this.waveCursorColorButton = new JButton();
        this.waveSelectionColorPanel = new JPanel();
        this.waveBackgroundColorPanel = new JPanel();
        this.waveBackgroundColorButton = new JButton();
        this.waveFillColorLabel = new JLabel();
        this.waveFillColorPanel = new JPanel();
        this.waveFillColorButton = new JButton();
        this.waveCursorWaveColorLabel = new JLabel();
        this.waveCursorWaveColorPanel = new JPanel();
        this.waveCursorWaveColorButton = new JButton();
        this.colorChooser.setName("colorChooser");
        this.setName("Form");
        this.waveSelectionColorButton.setText(this.resourceBundle.getString("selectButton.text"));
        this.waveSelectionColorButton.setName("waveSelectionColorButton");
        this.waveSelectionColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveColorPanel.this.waveSelectionColorButtonActionPerformed(evt);
            }
        });
        this.waveColorLabel.setText(this.resourceBundle.getString("waveColorLabel.text"));
        this.waveColorLabel.setName("waveColorLabel");
        this.waveColorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.waveColorPanel.setName("waveColorPanel");
        GroupLayout waveColorPanelLayout = new GroupLayout(this.waveColorPanel);
        this.waveColorPanel.setLayout(waveColorPanelLayout);
        waveColorPanelLayout.setHorizontalGroup(waveColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        waveColorPanelLayout.setVerticalGroup(waveColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 21, Short.MAX_VALUE));
        this.waveColorButton.setText(this.resourceBundle.getString("selectButton.text"));
        this.waveColorButton.setName("waveColorButton");
        this.waveColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveColorPanel.this.waveColorButtonActionPerformed(evt);
            }
        });
        this.waveSelectionColorLabel.setText(this.resourceBundle.getString("waveSelectionColorLabel.text"));
        this.waveSelectionColorLabel.setName("waveSelectionColorLabel");
        this.waveBackgroundColorLabel.setText(this.resourceBundle.getString("waveBackgroundColorLabel.text"));
        this.waveBackgroundColorLabel.setName("waveBackgroundColorLabel");
        this.waveCursorColorLabel.setText(this.resourceBundle.getString("waveCursorColorLabel.text"));
        this.waveCursorColorLabel.setName("waveCursorColorLabel");
        this.fillDefaultButton.setText(this.resourceBundle.getString("fillDefaultButton.text"));
        this.fillDefaultButton.setName("fillDefaultButton");
        this.fillDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveColorPanel.this.fillDefaultButtonActionPerformed(evt);
            }
        });
        this.fillCurrentButton.setText(this.resourceBundle.getString("fillCurrentButton.text"));
        this.fillCurrentButton.setName("fillCurrentButton");
        this.fillCurrentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveColorPanel.this.fillCurrentButtonActionPerformed(evt);
            }
        });
        this.waveCursorColorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.waveCursorColorPanel.setName("waveCursorColorPanel");
        GroupLayout waveCursorColorPanelLayout = new GroupLayout(this.waveCursorColorPanel);
        this.waveCursorColorPanel.setLayout(waveCursorColorPanelLayout);
        waveCursorColorPanelLayout.setHorizontalGroup(waveCursorColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        waveCursorColorPanelLayout.setVerticalGroup(waveCursorColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 21, Short.MAX_VALUE));
        this.waveCursorColorButton.setText(this.resourceBundle.getString("selectButton.text"));
        this.waveCursorColorButton.setName("waveCursorColorButton");
        this.waveCursorColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveColorPanel.this.waveCursorColorButtonActionPerformed(evt);
            }
        });
        this.waveSelectionColorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.waveSelectionColorPanel.setName("waveSelectionColorPanel");
        GroupLayout waveSelectionColorPanelLayout = new GroupLayout(this.waveSelectionColorPanel);
        this.waveSelectionColorPanel.setLayout(waveSelectionColorPanelLayout);
        waveSelectionColorPanelLayout.setHorizontalGroup(waveSelectionColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        waveSelectionColorPanelLayout.setVerticalGroup(waveSelectionColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.waveBackgroundColorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.waveBackgroundColorPanel.setName("waveBackgroundColorPanel");
        GroupLayout waveBackgroundColorPanelLayout = new GroupLayout(this.waveBackgroundColorPanel);
        this.waveBackgroundColorPanel.setLayout(waveBackgroundColorPanelLayout);
        waveBackgroundColorPanelLayout.setHorizontalGroup(waveBackgroundColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        waveBackgroundColorPanelLayout.setVerticalGroup(waveBackgroundColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 21, Short.MAX_VALUE));
        this.waveBackgroundColorButton.setText(this.resourceBundle.getString("selectButton.text"));
        this.waveBackgroundColorButton.setName("waveBackgroundColorButton");
        this.waveBackgroundColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveColorPanel.this.waveBackgroundColorButtonActionPerformed(evt);
            }
        });
        this.waveFillColorLabel.setText(this.resourceBundle.getString("waveFillColorLabel.text"));
        this.waveFillColorLabel.setName("waveFillColorLabel");
        this.waveFillColorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.waveFillColorPanel.setName("waveFillColorPanel");
        GroupLayout waveFillColorPanelLayout = new GroupLayout(this.waveFillColorPanel);
        this.waveFillColorPanel.setLayout(waveFillColorPanelLayout);
        waveFillColorPanelLayout.setHorizontalGroup(waveFillColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        waveFillColorPanelLayout.setVerticalGroup(waveFillColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 21, Short.MAX_VALUE));
        this.waveFillColorButton.setText(this.resourceBundle.getString("selectButton.text"));
        this.waveFillColorButton.setName("waveFillColorButton");
        this.waveFillColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveColorPanel.this.waveFillColorButtonActionPerformed(evt);
            }
        });
        this.waveCursorWaveColorLabel.setText(this.resourceBundle.getString("waveCursorWaveColorLabel.text"));
        this.waveCursorWaveColorLabel.setName("waveCursorWaveColorLabel");
        this.waveCursorWaveColorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.waveCursorWaveColorPanel.setName("waveCursorWaveColorPanel");
        GroupLayout waveCursorWaveColorPanelLayout = new GroupLayout(this.waveCursorWaveColorPanel);
        this.waveCursorWaveColorPanel.setLayout(waveCursorWaveColorPanelLayout);
        waveCursorWaveColorPanelLayout.setHorizontalGroup(waveCursorWaveColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        waveCursorWaveColorPanelLayout.setVerticalGroup(waveCursorWaveColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.waveCursorWaveColorButton.setText(this.resourceBundle.getString("selectButton.text"));
        this.waveCursorWaveColorButton.setName("waveCursorWaveColorButton");
        this.waveCursorWaveColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveColorPanel.this.waveCursorWaveColorButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.waveFillColorPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.waveBackgroundColorPanel, -1, -1, Short.MAX_VALUE).addComponent(this.waveSelectionColorPanel, -1, -1, Short.MAX_VALUE)).addGap(6, 6, 6))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.waveSelectionColorButton, -1, -1, Short.MAX_VALUE).addComponent(this.waveBackgroundColorButton, -1, -1, Short.MAX_VALUE).addComponent(this.waveFillColorButton, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.waveColorPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.waveColorButton)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.waveCursorWaveColorPanel, -1, -1, Short.MAX_VALUE).addComponent(this.waveCursorColorPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.waveCursorWaveColorButton, -1, -1, Short.MAX_VALUE).addComponent(this.waveCursorColorButton, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.waveFillColorLabel).addComponent(this.waveBackgroundColorLabel).addComponent(this.waveSelectionColorLabel).addGroup(layout.createSequentialGroup().addComponent(this.fillCurrentButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fillDefaultButton)).addComponent(this.waveCursorColorLabel).addComponent(this.waveCursorWaveColorLabel).addComponent(this.waveColorLabel)).addGap(0, 308, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.waveColorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.waveColorButton).addComponent(this.waveColorPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.waveFillColorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.waveFillColorPanel, -2, -1, -2)).addComponent(this.waveFillColorButton)).addGap(18, 18, 18).addComponent(this.waveBackgroundColorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.waveBackgroundColorPanel, -2, -1, -2).addComponent(this.waveBackgroundColorButton)).addGap(18, 18, 18).addComponent(this.waveSelectionColorLabel).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.waveSelectionColorPanel, -1, -1, Short.MAX_VALUE).addComponent(this.waveSelectionColorButton)).addGap(18, 18, 18).addComponent(this.waveCursorColorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.waveCursorColorPanel, -2, -1, -2).addComponent(this.waveCursorColorButton)).addGap(18, 18, 18).addComponent(this.waveCursorWaveColorLabel).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.waveCursorWaveColorPanel, -1, -1, Short.MAX_VALUE).addComponent(this.waveCursorWaveColorButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fillCurrentButton).addComponent(this.fillDefaultButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void waveColorButtonActionPerformed(ActionEvent evt) {
        this.colorChooser.setColor(this.waveColorPanel.getBackground());
        JDialog dialog = JColorChooser.createDialog(this, this.resourceBundle.getString("JColorChooser.title"), true, this.colorChooser, e -> {
            this.setWaveColor(this.colorChooser.getColor());
            this.setModified(true);
        }, null);
        dialog.setVisible(true);
    }

    private void waveBackgroundColorButtonActionPerformed(ActionEvent evt) {
        this.colorChooser.setColor(this.waveBackgroundColorPanel.getBackground());
        JDialog dialog = JColorChooser.createDialog(this, this.resourceBundle.getString("JColorChooser.title"), true, this.colorChooser, e -> {
            this.setWaveBackgroundColor(this.colorChooser.getColor());
            this.setModified(true);
        }, null);
        dialog.setVisible(true);
    }

    private void waveSelectionColorButtonActionPerformed(ActionEvent evt) {
        this.colorChooser.setColor(this.waveSelectionColorPanel.getBackground());
        JDialog dialog = JColorChooser.createDialog(this, this.resourceBundle.getString("JColorChooser.title"), true, this.colorChooser, e -> {
            this.setWaveSelectionColor(this.colorChooser.getColor());
            this.setModified(true);
        }, null);
        dialog.setVisible(true);
    }

    private void waveCursorColorButtonActionPerformed(ActionEvent evt) {
        this.colorChooser.setColor(this.waveCursorColorPanel.getBackground());
        JDialog dialog = JColorChooser.createDialog(this, this.resourceBundle.getString("JColorChooser.title"), true, this.colorChooser, e -> {
            this.setWaveCursorColor(this.colorChooser.getColor());
            this.setModified(true);
        }, null);
        dialog.setVisible(true);
    }

    private void fillCurrentButtonActionPerformed(ActionEvent evt) {
        this.setWaveColorsFromArray(this.waveColorService.getCurrentWaveColors());
    }

    private void fillDefaultButtonActionPerformed(ActionEvent evt) {
        this.setDefaultAudioPanelColors();
    }

    private void waveFillColorButtonActionPerformed(ActionEvent evt) {
        this.colorChooser.setColor(this.waveFillColorPanel.getBackground());
        JDialog dialog = JColorChooser.createDialog(this, this.resourceBundle.getString("JColorChooser.title"), true, this.colorChooser, e -> {
            this.setWaveFillColor(this.colorChooser.getColor());
            this.setModified(true);
        }, null);
        dialog.setVisible(true);
    }

    private void waveCursorWaveColorButtonActionPerformed(ActionEvent evt) {
        this.colorChooser.setColor(this.waveCursorWaveColorPanel.getBackground());
        JDialog dialog = JColorChooser.createDialog(this, this.resourceBundle.getString("JColorChooser.title"), true, this.colorChooser, e -> {
            this.setWaveCursorWaveColor(this.colorChooser.getColor());
            this.setModified(true);
        }, null);
        dialog.setVisible(true);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new WaveColorPanel());
    }

    public void setWaveColorsFromArray(Color[] colors) {
        this.setWaveColor(colors[0]);
        this.setWaveFillColor(colors[1]);
        this.setWaveCursorColor(colors[2]);
        this.setWaveCursorWaveColor(colors[3]);
        this.setWaveBackgroundColor(colors[4]);
        this.setWaveSelectionColor(colors[5]);
    }

    @Nonnull
    public Color[] getWaveColorsAsArray() {
        Color[] colors = new Color[]{this.getWaveColor(), this.getWaveFillColor(), this.getWaveCursorColor(), this.getWaveCursorWaveColor(), this.getWaveBackgroundColor(), this.getWaveSelectionColor()};
        return colors;
    }

    private void setModified(boolean modified) {
        if (this.optionsModifiedListener != null) {
            this.optionsModifiedListener.wasModified();
        }
    }

    public void setOptionsModifiedListener(OptionsModifiedListener listener) {
        this.optionsModifiedListener = listener;
    }
}

