/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.exbin.framework.editor.wave.AudioControlApi;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

public class AudioStatusPanel
extends JPanel {
    private final AudioControlApi playControl;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(AudioStatusPanel.class);
    private JTextField currentTimeTextField;
    private JButton playButton;
    private JButton stopButton;
    private JSlider volumeSlider;

    public AudioStatusPanel(AudioControlApi playControl) {
        this.playControl = playControl;
        this.initComponents();
    }

    private void initComponents() {
        this.currentTimeTextField = new JTextField();
        this.playButton = new JButton();
        this.volumeSlider = new JSlider();
        this.stopButton = new JButton();
        this.setName("Form");
        this.currentTimeTextField.setEditable(false);
        this.currentTimeTextField.setHorizontalAlignment(0);
        this.currentTimeTextField.setText("0:00.00");
        this.currentTimeTextField.setToolTipText(this.resourceBundle.getString("currentTimeTextField.toolTipText"));
        this.currentTimeTextField.setName("currentTimeTextField");
        this.playButton.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/wave/resources/images/actions/play16.png")));
        this.playButton.setToolTipText(this.resourceBundle.getString("playButton.toolTipText"));
        this.playButton.setFocusable(false);
        this.playButton.setHorizontalTextPosition(0);
        this.playButton.setName("playButton");
        this.playButton.setVerticalTextPosition(3);
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AudioStatusPanel.this.playButtonActionPerformed(evt);
            }
        });
        this.volumeSlider.setToolTipText(this.resourceBundle.getString("volumeSlider.toolTipText"));
        this.volumeSlider.setValue(100);
        this.volumeSlider.setFocusable(false);
        this.volumeSlider.setName("volumeSlider");
        this.volumeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                AudioStatusPanel.this.volumeSliderStateChanged(evt);
            }
        });
        this.stopButton.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/wave/resources/images/actions/stop16.png")));
        this.stopButton.setToolTipText(this.resourceBundle.getString("stopButton.toolTipText"));
        this.stopButton.setFocusable(false);
        this.stopButton.setHorizontalTextPosition(0);
        this.stopButton.setName("stopButton");
        this.stopButton.setVerticalTextPosition(3);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AudioStatusPanel.this.stopButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.playButton, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopButton, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.currentTimeTextField, -2, 96, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 516, Short.MAX_VALUE).addComponent(this.volumeSlider, -2, 137, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.playButton, -1, -1, Short.MAX_VALUE).addComponent(this.currentTimeTextField).addComponent(this.volumeSlider, -1, -1, Short.MAX_VALUE).addComponent(this.stopButton, -1, -1, Short.MAX_VALUE));
    }

    private void playButtonActionPerformed(ActionEvent evt) {
        this.playControl.performPlay();
    }

    private void volumeSliderStateChanged(ChangeEvent evt) {
        this.playControl.setVolume(this.volumeSlider.getValue());
    }

    private void stopButtonActionPerformed(ActionEvent evt) {
        this.playControl.performStop();
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new AudioStatusPanel(null));
    }

    public void setCurrentTime(String positionTime) {
        this.currentTimeTextField.setText(positionTime);
    }

    public void setPlayButtonIcon(ImageIcon imageIcon) {
        this.playButton.setIcon(imageIcon);
    }
}

