/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave.action;

import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.wave.gui.AudioPanel;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.utils.ActionUtils;

@ParametersAreNonnullByDefault
public class AudioOperationActions {
    public static final String AUDIO_REVERSE_ACTION_ID = "audioReverseAction";
    private EditorProvider editorProvider;
    private XBApplication application;
    private ResourceBundle resourceBundle;
    private Action audioReverseAction;

    public void setup(XBApplication application, EditorProvider editorProvider, ResourceBundle resourceBundle) {
        this.application = application;
        this.editorProvider = editorProvider;
        this.resourceBundle = resourceBundle;
    }

    @Nonnull
    public Action getRevertAction() {
        if (this.audioReverseAction == null) {
            this.audioReverseAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Optional activeFile = AudioOperationActions.this.editorProvider.getActiveFile();
                    if (!activeFile.isPresent()) {
                        throw new IllegalStateException();
                    }
                    AudioPanel audioPanel = (AudioPanel)((FileHandler)activeFile.get()).getComponent();
                    audioPanel.performTransformReverse();
                }
            };
            ActionUtils.setupAction((Action)this.audioReverseAction, (ResourceBundle)this.resourceBundle, (String)AUDIO_REVERSE_ACTION_ID);
        }
        return this.audioReverseAction;
    }
}

