/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.frame.action;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.XBApplicationFrame;
import org.exbin.framework.utils.ActionUtils;

@ParametersAreNonnullByDefault
public class FrameActions {
    public static final String VIEW_TOOL_BAR_ACTION_ID = "viewToolBarAction";
    public static final String VIEW_TOOL_BAR_CAPTIONS_ACTION_ID = "viewToolBarCaptionsAction";
    public static final String VIEW_STATUS_BAR_ACTION_ID = "viewStatusBarAction";
    private XBApplication application;
    private ResourceBundle resourceBundle;
    private XBApplicationFrame frame;
    private AbstractAction viewToolBarAction;
    private AbstractAction viewStatusBarAction;
    private AbstractAction viewToolBarCaptionsAction;

    public void setup(XBApplication application, ResourceBundle resourceBundle) {
        this.application = application;
        this.resourceBundle = resourceBundle;
    }

    public void setApplicationFrame(XBApplicationFrame frame) {
        this.frame = frame;
    }

    public void notifyFrameUpdated() {
        if (this.viewToolBarAction != null) {
            this.viewToolBarAction.putValue("SwingSelectedKey", this.frame.isToolBarVisible());
        }
        if (this.viewToolBarCaptionsAction != null) {
            this.viewToolBarCaptionsAction.putValue("SwingSelectedKey", this.frame.isToolBarCaptionsVisible());
        }
        if (this.viewStatusBarAction != null) {
            this.viewStatusBarAction.putValue("SwingSelectedKey", this.frame.isStatusBarVisible());
        }
    }

    @Nonnull
    public Action getViewToolBarAction() {
        if (this.viewToolBarAction == null) {
            this.viewToolBarAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object source = e.getSource();
                    if (source instanceof JMenuItem) {
                        FrameActions.this.frame.setToolBarVisible(((JMenuItem)source).isSelected());
                    }
                }
            };
            ActionUtils.setupAction((Action)this.viewToolBarAction, (ResourceBundle)this.resourceBundle, (String)VIEW_TOOL_BAR_ACTION_ID);
            this.viewToolBarAction.putValue("SwingSelectedKey", true);
            this.viewToolBarAction.putValue("type", ActionUtils.ActionType.CHECK);
        }
        return this.viewToolBarAction;
    }

    @Nonnull
    public Action getViewToolBarCaptionsAction() {
        if (this.viewToolBarCaptionsAction == null) {
            this.viewToolBarCaptionsAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object source = e.getSource();
                    if (source instanceof JMenuItem) {
                        FrameActions.this.frame.setToolBarCaptionsVisible(((JMenuItem)source).isSelected());
                    }
                }
            };
            ActionUtils.setupAction((Action)this.viewToolBarCaptionsAction, (ResourceBundle)this.resourceBundle, (String)VIEW_TOOL_BAR_CAPTIONS_ACTION_ID);
            this.viewToolBarCaptionsAction.putValue("SwingSelectedKey", true);
            this.viewToolBarCaptionsAction.putValue("type", ActionUtils.ActionType.CHECK);
        }
        return this.viewToolBarCaptionsAction;
    }

    @Nonnull
    public Action getViewStatusBarAction() {
        if (this.viewStatusBarAction == null) {
            this.viewStatusBarAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object source = e.getSource();
                    if (source instanceof JMenuItem) {
                        FrameActions.this.frame.setStatusBarVisible(((JMenuItem)source).isSelected());
                    }
                }
            };
            ActionUtils.setupAction((Action)this.viewStatusBarAction, (ResourceBundle)this.resourceBundle, (String)VIEW_STATUS_BAR_ACTION_ID);
            this.viewStatusBarAction.putValue("SwingSelectedKey", true);
            this.viewStatusBarAction.putValue("type", ActionUtils.ActionType.CHECK);
        }
        return this.viewStatusBarAction;
    }
}

