/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.auxiliary.binary_data.delta;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.auxiliary.binary_data.paged.PagedData;

@ParametersAreNonnullByDefault
public class MemoryDataSource
implements EditableBinaryData {
    @Nonnull
    private final EditableBinaryData data;

    public MemoryDataSource() {
        this.data = new PagedData();
    }

    public MemoryDataSource(EditableBinaryData data) {
        this.data = data;
    }

    public MemoryDataSource(byte[] data) {
        this.data = new PagedData();
        this.data.insert(0L, data);
    }

    public void setDataSize(long size) {
        this.data.setDataSize(size);
    }

    public void setByte(long position, byte value) {
        this.data.setByte(position, value);
    }

    public void insert(long startFrom, long length) {
        this.data.insert(startFrom, length);
    }

    public void insert(long startFrom, byte[] insertedData) {
        this.data.insert(startFrom, insertedData);
    }

    public void insert(long startFrom, BinaryData insertedData) {
        this.data.insert(startFrom, insertedData);
    }

    public void remove(long startFrom, long length) {
        this.data.remove(startFrom, length);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public long getDataSize() {
        return this.data.getDataSize();
    }

    public byte getByte(long position) {
        return this.data.getByte(position);
    }

    public void saveToStream(OutputStream outputStream) throws IOException {
        this.data.saveToStream(outputStream);
    }

    @Nonnull
    public BinaryData copy() {
        return this.data.copy();
    }

    @Nonnull
    public BinaryData copy(long startFrom, long length) {
        return this.data.copy(startFrom, length);
    }

    public void insertUninitialized(long startFrom, long length) {
        this.data.insertUninitialized(startFrom, length);
    }

    public void insert(long startFrom, byte[] insertedData, int insertedDataOffset, int insertedDataLength) {
        this.data.insert(startFrom, insertedData, insertedDataOffset, insertedDataLength);
    }

    public void insert(long startFrom, BinaryData insertedData, long insertedDataOffset, long insertedDataLength) {
        this.data.insert(startFrom, insertedData, insertedDataOffset, insertedDataLength);
    }

    public long insert(long startFrom, InputStream inputStream, long length) throws IOException {
        return this.data.insert(startFrom, inputStream, length);
    }

    public void replace(long targetPosition, BinaryData replacingData) {
        this.data.replace(targetPosition, replacingData);
    }

    public void replace(long targetPosition, BinaryData replacingData, long startFrom, long length) {
        this.data.replace(targetPosition, replacingData, startFrom, length);
    }

    public void replace(long targetPosition, byte[] replacingData) {
        this.data.replace(targetPosition, replacingData);
    }

    public void replace(long targetPosition, byte[] replacingData, int replacingDataOffset, int length) {
        this.data.replace(targetPosition, replacingData, replacingDataOffset, length);
    }

    public void fillData(long startFrom, long length) {
        this.data.fillData(startFrom, length);
    }

    public void fillData(long startFrom, long length, byte fill) {
        this.data.fillData(startFrom, length, fill);
    }

    public void clear() {
        this.data.clear();
    }

    public void loadFromStream(InputStream inputStream) throws IOException {
        this.data.loadFromStream(inputStream);
    }

    @Nonnull
    public OutputStream getDataOutputStream() {
        return this.data.getDataOutputStream();
    }

    public void copyToArray(long startFrom, byte[] target, int offset, int length) {
        this.data.copyToArray(startFrom, target, offset, length);
    }

    @Nonnull
    public InputStream getDataInputStream() {
        return this.data.getDataInputStream();
    }

    public void dispose() {
        this.data.dispose();
    }
}

