/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.search.service.impl;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.highlight.swing.extended.ExtendedHighlightCodeAreaPainter;
import org.exbin.bined.highlight.swing.extended.ExtendedHighlightNonAsciiCodeAreaPainter;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.framework.bined.search.ReplaceParameters;
import org.exbin.framework.bined.search.SearchCondition;
import org.exbin.framework.bined.search.SearchParameters;
import org.exbin.framework.bined.search.service.BinarySearchService;

@ParametersAreNonnullByDefault
public class BinarySearchServiceImpl
implements BinarySearchService {
    private static final int MAX_MATCHES_COUNT = 100;
    private final ExtCodeArea codeArea;
    private final SearchParameters lastSearchParameters = new SearchParameters();

    public BinarySearchServiceImpl(ExtCodeArea codeArea) {
        this.codeArea = codeArea;
    }

    @Override
    public void performFind(SearchParameters searchParameters, BinarySearchService.SearchStatusListener searchStatusListener) {
        long position;
        ExtendedHighlightNonAsciiCodeAreaPainter painter = (ExtendedHighlightNonAsciiCodeAreaPainter)this.codeArea.getPainter();
        SearchCondition condition = searchParameters.getCondition();
        searchStatusListener.clearStatus();
        if (condition.isEmpty()) {
            painter.clearMatches();
            this.codeArea.repaint();
            return;
        }
        switch (searchParameters.getSearchDirection()) {
            case FORWARD: {
                if (searchParameters.isSearchFromCursor()) {
                    position = this.codeArea.getCaretPosition().getDataPosition();
                    break;
                }
                position = 0L;
                break;
            }
            case BACKWARD: {
                long searchDataSize;
                if (searchParameters.isSearchFromCursor()) {
                    position = this.codeArea.getCaretPosition().getDataPosition() - 1L;
                    break;
                }
                switch (condition.getSearchMode()) {
                    case TEXT: {
                        searchDataSize = condition.getSearchText().length();
                        break;
                    }
                    case BINARY: {
                        searchDataSize = condition.getBinaryData().getDataSize();
                        break;
                    }
                    default: {
                        throw CodeAreaUtils.getInvalidTypeException((Enum)condition.getSearchMode());
                    }
                }
                position = this.codeArea.getDataSize() - searchDataSize;
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)searchParameters.getSearchDirection());
            }
        }
        searchParameters.setStartPosition(position);
        switch (condition.getSearchMode()) {
            case TEXT: {
                this.searchForText(searchParameters, searchStatusListener);
                break;
            }
            case BINARY: {
                this.searchForBinaryData(searchParameters, searchStatusListener);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)condition.getSearchMode());
            }
        }
    }

    private void searchForBinaryData(SearchParameters searchParameters, BinarySearchService.SearchStatusListener searchStatusListener) {
        ExtendedHighlightNonAsciiCodeAreaPainter painter = (ExtendedHighlightNonAsciiCodeAreaPainter)this.codeArea.getPainter();
        SearchCondition condition = searchParameters.getCondition();
        BinaryData searchData = condition.getBinaryData();
        long searchDataSize = searchData.getDataSize();
        BinaryData data = this.codeArea.getContentData();
        ArrayList<ExtendedHighlightCodeAreaPainter.SearchMatch> foundMatches = new ArrayList<ExtendedHighlightCodeAreaPainter.SearchMatch>();
        long dataSize = data.getDataSize();
        for (long position = searchParameters.getStartPosition(); position >= 0L && position <= dataSize - searchDataSize; ++position) {
            int matchLength = 0;
            while ((long)matchLength < searchDataSize && data.getByte(position + (long)matchLength) == searchData.getByte((long)matchLength)) {
                ++matchLength;
            }
            if ((long)matchLength != searchDataSize) continue;
            ExtendedHighlightCodeAreaPainter.SearchMatch match = new ExtendedHighlightCodeAreaPainter.SearchMatch();
            match.setPosition(position);
            match.setLength(searchDataSize);
            if (searchParameters.getSearchDirection() == SearchParameters.SearchDirection.BACKWARD) {
                foundMatches.add(0, match);
            } else {
                foundMatches.add(match);
            }
            if (foundMatches.size() == 100 || searchParameters.getMatchMode() == SearchParameters.MatchMode.SINGLE) break;
        }
        painter.setMatches(foundMatches);
        if (!foundMatches.isEmpty()) {
            if (searchParameters.getSearchDirection() == SearchParameters.SearchDirection.BACKWARD) {
                painter.setCurrentMatchIndex(foundMatches.size() - 1);
            } else {
                painter.setCurrentMatchIndex(0);
            }
            ExtendedHighlightCodeAreaPainter.SearchMatch firstMatch = Objects.requireNonNull(painter.getCurrentMatch());
            this.codeArea.revealPosition(firstMatch.getPosition(), 0, this.codeArea.getActiveSection());
        }
        this.lastSearchParameters.setFromParameters(searchParameters);
        searchStatusListener.setStatus(new BinarySearchService.FoundMatches(foundMatches.size(), foundMatches.isEmpty() ? -1 : painter.getCurrentMatchIndex()), searchParameters.getMatchMode());
        this.codeArea.repaint();
    }

    private void searchForText(SearchParameters searchParameters, BinarySearchService.SearchStatusListener searchStatusListener) {
        int maxBytesPerChar;
        ExtendedHighlightNonAsciiCodeAreaPainter painter = (ExtendedHighlightNonAsciiCodeAreaPainter)this.codeArea.getPainter();
        SearchCondition condition = searchParameters.getCondition();
        long position = searchParameters.getStartPosition();
        String findText = searchParameters.isMatchCase() ? condition.getSearchText() : condition.getSearchText().toLowerCase();
        long searchDataSize = findText.length();
        BinaryData data = this.codeArea.getContentData();
        ArrayList<ExtendedHighlightCodeAreaPainter.SearchMatch> foundMatches = new ArrayList<ExtendedHighlightCodeAreaPainter.SearchMatch>();
        Charset charset = this.codeArea.getCharset();
        try {
            CharsetEncoder encoder = charset.newEncoder();
            maxBytesPerChar = (int)encoder.maxBytesPerChar();
        }
        catch (UnsupportedOperationException ex) {
            maxBytesPerChar = 8;
        }
        byte[] charData = new byte[maxBytesPerChar];
        long dataSize = data.getDataSize();
        block6: while (position >= 0L && position <= dataSize - searchDataSize) {
            int matchCharLength = 0;
            int matchLength = 0;
            while ((long)matchCharLength < searchDataSize) {
                long searchPosition = position + (long)matchLength;
                int bytesToUse = maxBytesPerChar;
                if (searchPosition + (long)bytesToUse > dataSize) {
                    bytesToUse = (int)(dataSize - searchPosition);
                }
                data.copyToArray(searchPosition, charData, 0, bytesToUse);
                char singleChar = new String(charData, charset).charAt(0);
                String singleCharString = String.valueOf(singleChar);
                int characterLength = singleCharString.getBytes(charset).length;
                if (searchParameters.isMatchCase() ? singleChar != findText.charAt(matchCharLength) : singleCharString.toLowerCase().charAt(0) != findText.charAt(matchCharLength)) break;
                ++matchCharLength;
                matchLength += characterLength;
            }
            if (matchCharLength == findText.length()) {
                ExtendedHighlightCodeAreaPainter.SearchMatch match = new ExtendedHighlightCodeAreaPainter.SearchMatch();
                match.setPosition(position);
                match.setLength((long)matchLength);
                if (searchParameters.getSearchDirection() == SearchParameters.SearchDirection.BACKWARD) {
                    foundMatches.add(0, match);
                } else {
                    foundMatches.add(match);
                }
                if (foundMatches.size() == 100 || searchParameters.getMatchMode() == SearchParameters.MatchMode.SINGLE) break;
            }
            switch (searchParameters.getSearchDirection()) {
                case FORWARD: {
                    ++position;
                    continue block6;
                }
                case BACKWARD: {
                    --position;
                    continue block6;
                }
            }
            throw CodeAreaUtils.getInvalidTypeException((Enum)searchParameters.getSearchDirection());
        }
        painter.setMatches(foundMatches);
        if (!foundMatches.isEmpty()) {
            if (searchParameters.getSearchDirection() == SearchParameters.SearchDirection.BACKWARD) {
                painter.setCurrentMatchIndex(foundMatches.size() - 1);
            } else {
                painter.setCurrentMatchIndex(0);
            }
            ExtendedHighlightCodeAreaPainter.SearchMatch firstMatch = painter.getCurrentMatch();
            this.codeArea.revealPosition(firstMatch.getPosition(), 0, this.codeArea.getActiveSection());
        }
        this.lastSearchParameters.setFromParameters(searchParameters);
        searchStatusListener.setStatus(new BinarySearchService.FoundMatches(foundMatches.size(), foundMatches.isEmpty() ? -1 : painter.getCurrentMatchIndex()), searchParameters.getMatchMode());
        this.codeArea.repaint();
    }

    @Override
    public void setMatchPosition(int matchPosition) {
        ExtendedHighlightNonAsciiCodeAreaPainter painter = (ExtendedHighlightNonAsciiCodeAreaPainter)this.codeArea.getPainter();
        painter.setCurrentMatchIndex(matchPosition);
        ExtendedHighlightCodeAreaPainter.SearchMatch currentMatch = painter.getCurrentMatch();
        this.codeArea.revealPosition(currentMatch.getPosition(), 0, this.codeArea.getActiveSection());
        this.codeArea.repaint();
    }

    @Override
    public void performFindAgain(BinarySearchService.SearchStatusListener searchStatusListener) {
        ExtendedHighlightNonAsciiCodeAreaPainter painter = (ExtendedHighlightNonAsciiCodeAreaPainter)this.codeArea.getPainter();
        List foundMatches = painter.getMatches();
        int matchesCount = foundMatches.size();
        if (matchesCount > 0) {
            block0 : switch (this.lastSearchParameters.getMatchMode()) {
                case MULTIPLE: {
                    if (matchesCount <= 1) break;
                    int currentMatchIndex = painter.getCurrentMatchIndex();
                    this.setMatchPosition(currentMatchIndex < matchesCount - 1 ? currentMatchIndex + 1 : 0);
                    searchStatusListener.setStatus(new BinarySearchService.FoundMatches(foundMatches.size(), painter.getCurrentMatchIndex()), this.lastSearchParameters.getMatchMode());
                    break;
                }
                case SINGLE: {
                    switch (this.lastSearchParameters.getSearchDirection()) {
                        case FORWARD: {
                            this.lastSearchParameters.setStartPosition(((ExtendedHighlightCodeAreaPainter.SearchMatch)foundMatches.get(0)).getPosition() + 1L);
                            break;
                        }
                        case BACKWARD: {
                            ExtendedHighlightCodeAreaPainter.SearchMatch match = (ExtendedHighlightCodeAreaPainter.SearchMatch)foundMatches.get(0);
                            this.lastSearchParameters.setStartPosition(match.getPosition() - 1L);
                        }
                    }
                    SearchCondition condition = this.lastSearchParameters.getCondition();
                    switch (condition.getSearchMode()) {
                        case TEXT: {
                            this.searchForText(this.lastSearchParameters, searchStatusListener);
                            break block0;
                        }
                        case BINARY: {
                            this.searchForBinaryData(this.lastSearchParameters, searchStatusListener);
                            break block0;
                        }
                    }
                    throw CodeAreaUtils.getInvalidTypeException((Enum)condition.getSearchMode());
                }
            }
        }
    }

    @Override
    public void performReplace(SearchParameters searchParameters, ReplaceParameters replaceParameters) {
        SearchCondition replaceCondition = replaceParameters.getCondition();
        ExtendedHighlightNonAsciiCodeAreaPainter painter = (ExtendedHighlightNonAsciiCodeAreaPainter)this.codeArea.getPainter();
        ExtendedHighlightCodeAreaPainter.SearchMatch currentMatch = painter.getCurrentMatch();
        if (currentMatch != null) {
            EditableBinaryData editableData = (EditableBinaryData)this.codeArea.getContentData();
            editableData.remove(currentMatch.getPosition(), currentMatch.getLength());
            if (replaceCondition.getSearchMode() == SearchCondition.SearchMode.BINARY) {
                editableData.insert(currentMatch.getPosition(), replaceCondition.getBinaryData());
            } else {
                editableData.insert(currentMatch.getPosition(), replaceCondition.getSearchText().getBytes(this.codeArea.getCharset()));
            }
            painter.getMatches().remove(currentMatch);
            this.codeArea.repaint();
        }
    }

    @Override
    @Nonnull
    public SearchParameters getLastSearchParameters() {
        return this.lastSearchParameters;
    }

    @Override
    public void clearMatches() {
        ExtendedHighlightNonAsciiCodeAreaPainter painter = (ExtendedHighlightNonAsciiCodeAreaPainter)this.codeArea.getPainter();
        painter.clearMatches();
    }
}

