/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.parser_tree;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlock;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBDefaultDocument;
import org.exbin.xbup.core.block.XBDocument;
import org.exbin.xbup.core.parser.XBParserState;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBListener;
import org.exbin.xbup.core.parser.basic.XBProducer;
import org.exbin.xbup.core.parser.basic.XBProvider;
import org.exbin.xbup.parser_tree.XBTreeNode;

@ParametersAreNonnullByDefault
public class XBTreeWriter
implements XBProvider,
XBProducer {
    private final XBDocument source;
    private XBBlock block;
    private XBParserState state = XBParserState.BLOCK_BEGIN;
    private int attributePosition = 0;
    private int childPosition = 0;
    private final List<Integer> childPositions = new ArrayList<Integer>();

    public XBTreeWriter(XBDocument source) {
        this.source = source;
        this.block = source.getRootBlock().orElse(null);
    }

    public XBTreeWriter(XBBlock sourceBlock) {
        this((XBDocument)new XBDefaultDocument(sourceBlock));
    }

    public void produceXB(XBListener listener, boolean recursive) throws XBProcessingException, IOException {
        switch (this.state) {
            case BLOCK_BEGIN: {
                listener.beginXB(this.block.getTerminationMode());
                this.attributePosition = 0;
                this.childPosition = 0;
                this.state = this.block.getDataMode() == XBBlockDataMode.DATA_BLOCK ? XBParserState.DATA_PART : XBParserState.ATTRIBUTE_PART;
                break;
            }
            case DATA_PART: {
                listener.dataXB(this.block.getData());
                this.state = XBParserState.BLOCK_END;
                break;
            }
            case ATTRIBUTE_PART: {
                if (this.attributePosition < this.block.getAttributesCount()) {
                    listener.attribXB(this.block.getAttributeAt(this.attributePosition));
                    ++this.attributePosition;
                    break;
                }
                this.state = XBParserState.CHILDREN_PART;
            }
            case CHILDREN_PART: {
                if (recursive && this.childPosition < this.block.getChildrenCount()) {
                    this.block = this.block.getChildAt(this.childPosition);
                    this.childPositions.add(this.childPosition + 1);
                    this.state = XBParserState.BLOCK_BEGIN;
                    this.produceXB(listener, recursive);
                    break;
                }
                this.state = XBParserState.BLOCK_END;
            }
            case BLOCK_END: {
                if (!this.childPositions.isEmpty()) {
                    this.childPosition = this.childPositions.remove(this.childPositions.size() - 1);
                    this.block = this.block.getParentBlock().orElse(null);
                    this.state = XBParserState.CHILDREN_PART;
                    listener.endXB();
                    break;
                }
                if (this.source.getTailDataSize() > 0L) {
                    listener.dataXB((InputStream)this.source.getTailData().get());
                    this.state = XBParserState.TAIL_DATA;
                    break;
                }
            }
            case TAIL_DATA: {
                listener.endXB();
                this.state = XBParserState.EOF;
                break;
            }
            case EOF: {
                throw new XBProcessingException("Reading after block end", XBProcessingExceptionType.READING_AFTER_END);
            }
            default: {
                throw new XBProcessingException("Unexpected state", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
        }
    }

    public void produceXB(XBListener listener) {
        try {
            this.produceXB(listener, true);
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBTreeNode.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean isFinished() {
        return this.state == XBParserState.EOF;
    }

    public void attachXBListener(XBListener listener) {
        try {
            while (!this.isFinished()) {
                this.produceXB(listener, true);
            }
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBTreeWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

