/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.about.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.table.DefaultTableModel;
import org.exbin.framework.about.gui.AboutAuthorsPanel;
import org.exbin.framework.about.gui.AboutModulesPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.popup.DefaultPopupMenu;
import org.exbin.framework.popup.LinkActionsHandler;
import org.exbin.framework.utils.ClipboardUtils;
import org.exbin.framework.utils.DesktopUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.UiUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class AboutPanel
extends JPanel {
    private ResourceBundle appBundle;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(AboutPanel.class);
    private JComponent sideComponent = null;
    private boolean darkMode = false;
    private final AboutModulesPanel aboutModulesPanel = new AboutModulesPanel();
    private final AboutAuthorsPanel aboutAuthorsPanel = new AboutAuthorsPanel();
    private String appHomepageLink;
    private JPanel aboutHeaderImagePanel;
    private JPanel aboutHeaderPanel;
    private JPanel aboutHeaderTitlePanel;
    private JLabel appDescLabel;
    private JLabel appHomepageLabel;
    private JLabel appTitleLabel;
    private JPanel applicationPanel;
    private JPanel environmentPanel;
    private JScrollPane environmentScrollPane;
    private JTable environmentTable;
    private JSeparator headerSeparator;
    private JLabel imageLabel;
    private JEditorPane licenseEditorPane;
    private JPanel licensePanel;
    private JScrollPane licenseScrollPane;
    private JTextField licenseTextField;
    private JTextField nameTextField;
    private JTabbedPane productTabbedPane;
    private JTextField vendorTextField;
    private JTextField versionTextField;

    public AboutPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.darkMode = UiUtils.isDarkUI();
        if (this.darkMode) {
            this.aboutHeaderPanel.setBackground(Color.BLACK);
            this.appTitleLabel.setForeground(Color.WHITE);
            this.appDescLabel.setForeground(Color.WHITE);
        }
        this.environmentTable.setModel(new DefaultTableModel(new Object[0][], new String[]{this.resourceBundle.getString("environmentTable.propertyColumn"), this.resourceBundle.getString("environmentTable.valueColumn")}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        });
        Properties systemProperties = System.getProperties();
        DefaultTableModel tableModel = (DefaultTableModel)this.environmentTable.getModel();
        Set<Map.Entry<Object, Object>> items = systemProperties.entrySet();
        items.stream().map(entry -> {
            Object[] line = new Object[]{entry.getKey(), entry.getValue()};
            return line;
        }).forEachOrdered(line -> tableModel.addRow((Object[])line));
        this.productTabbedPane.insertTab(this.resourceBundle.getString("authorsPanel.TabConstraints.tabTitle"), null, this.aboutAuthorsPanel, null, 1);
        this.productTabbedPane.insertTab(this.resourceBundle.getString("modulesPanel.TabConstraints.tabTitle"), null, this.aboutModulesPanel, null, 3);
    }

    private void initComponents() {
        this.aboutHeaderImagePanel = new JPanel();
        this.imageLabel = new JLabel();
        this.productTabbedPane = new JTabbedPane();
        this.applicationPanel = new JPanel();
        JLabel nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        JLabel versionLabel = new JLabel();
        this.versionTextField = new JTextField();
        JLabel vendorLabel = new JLabel();
        this.vendorTextField = new JTextField();
        JLabel appLicenseLabel = new JLabel();
        this.licenseTextField = new JTextField();
        JLabel homepageLabel = new JLabel();
        this.appHomepageLabel = new JLabel();
        this.licensePanel = new JPanel();
        this.licenseScrollPane = new JScrollPane();
        this.licenseEditorPane = new JEditorPane();
        this.environmentPanel = new JPanel();
        this.environmentScrollPane = new JScrollPane();
        this.environmentTable = new JTable();
        this.aboutHeaderPanel = new JPanel();
        this.headerSeparator = new JSeparator();
        this.aboutHeaderTitlePanel = new JPanel();
        this.appDescLabel = new JLabel();
        this.appTitleLabel = new JLabel();
        this.aboutHeaderImagePanel.setOpaque(false);
        this.imageLabel.setHorizontalAlignment(4);
        GroupLayout aboutHeaderImagePanelLayout = new GroupLayout(this.aboutHeaderImagePanel);
        this.aboutHeaderImagePanel.setLayout(aboutHeaderImagePanelLayout);
        aboutHeaderImagePanelLayout.setHorizontalGroup(aboutHeaderImagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(aboutHeaderImagePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.imageLabel, -1, 33, Short.MAX_VALUE)));
        aboutHeaderImagePanelLayout.setVerticalGroup(aboutHeaderImagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.imageLabel, -1, 39, Short.MAX_VALUE));
        this.setLayout(new BorderLayout());
        this.productTabbedPane.setMinimumSize(new Dimension(38, 15));
        this.applicationPanel.setAutoscrolls(true);
        nameLabel.setFont(nameLabel.getFont().deriveFont(nameLabel.getFont().getStyle() | 1));
        nameLabel.setText(this.resourceBundle.getString("nameLabel.text"));
        this.nameTextField.setEditable(false);
        this.nameTextField.setFont(new Font("Dialog", 1, 12));
        this.nameTextField.setBorder(null);
        versionLabel.setFont(versionLabel.getFont().deriveFont(versionLabel.getFont().getStyle() | 1));
        versionLabel.setText(this.resourceBundle.getString("versionLabel.text"));
        this.versionTextField.setEditable(false);
        this.versionTextField.setFont(new Font("Dialog", 1, 12));
        this.versionTextField.setBorder(null);
        vendorLabel.setFont(vendorLabel.getFont().deriveFont(vendorLabel.getFont().getStyle() | 1));
        vendorLabel.setText(this.resourceBundle.getString("vendorLabel.text"));
        this.vendorTextField.setEditable(false);
        this.vendorTextField.setFont(new Font("Dialog", 1, 12));
        this.vendorTextField.setBorder(null);
        appLicenseLabel.setFont(appLicenseLabel.getFont().deriveFont(appLicenseLabel.getFont().getStyle() | 1));
        appLicenseLabel.setText(this.resourceBundle.getString("appLicenseLabel.text"));
        this.licenseTextField.setEditable(false);
        this.licenseTextField.setFont(new Font("Dialog 12", 1, 12));
        this.licenseTextField.setBorder(null);
        homepageLabel.setFont(homepageLabel.getFont().deriveFont(homepageLabel.getFont().getStyle() | 1));
        homepageLabel.setText(this.resourceBundle.getString("homepageLabel.text"));
        this.appHomepageLabel.setCursor(new Cursor(12));
        this.appHomepageLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AboutPanel.this.appHomepageLabelMouseClicked(evt);
            }
        });
        GroupLayout applicationPanelLayout = new GroupLayout(this.applicationPanel);
        this.applicationPanel.setLayout(applicationPanelLayout);
        applicationPanelLayout.setHorizontalGroup(applicationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(applicationPanelLayout.createSequentialGroup().addContainerGap().addGroup(applicationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(vendorLabel).addComponent(homepageLabel).addComponent(appLicenseLabel).addComponent(versionLabel).addComponent(nameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(applicationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameTextField, -1, 296, Short.MAX_VALUE).addComponent(this.vendorTextField).addComponent(this.licenseTextField).addComponent(this.appHomepageLabel, -1, -1, Short.MAX_VALUE).addComponent(this.versionTextField)).addContainerGap()));
        applicationPanelLayout.setVerticalGroup(applicationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(applicationPanelLayout.createSequentialGroup().addContainerGap().addGroup(applicationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(nameLabel).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(applicationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(versionLabel).addComponent(this.versionTextField, -2, 15, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(applicationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(vendorLabel).addComponent(this.vendorTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(applicationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(appLicenseLabel).addComponent(this.licenseTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(applicationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(homepageLabel).addComponent(this.appHomepageLabel, -2, 17, -2)).addContainerGap(83, Short.MAX_VALUE)));
        this.productTabbedPane.addTab(this.resourceBundle.getString("applicationPanel.TabConstraints.tabTitle"), this.applicationPanel);
        this.licenseEditorPane.setEditable(false);
        this.licenseEditorPane.setContentType("text/html");
        this.licenseScrollPane.setViewportView(this.licenseEditorPane);
        GroupLayout licensePanelLayout = new GroupLayout(this.licensePanel);
        this.licensePanel.setLayout(licensePanelLayout);
        licensePanelLayout.setHorizontalGroup(licensePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.licenseScrollPane, GroupLayout.Alignment.TRAILING, -1, 398, Short.MAX_VALUE));
        licensePanelLayout.setVerticalGroup(licensePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.licenseScrollPane, -1, 198, Short.MAX_VALUE));
        this.productTabbedPane.addTab(this.resourceBundle.getString("licensePanel.TabConstraints.tabTitle"), this.licensePanel);
        this.environmentScrollPane.setViewportView(this.environmentTable);
        GroupLayout environmentPanelLayout = new GroupLayout(this.environmentPanel);
        this.environmentPanel.setLayout(environmentPanelLayout);
        environmentPanelLayout.setHorizontalGroup(environmentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.environmentScrollPane, -1, 398, Short.MAX_VALUE));
        environmentPanelLayout.setVerticalGroup(environmentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.environmentScrollPane, -1, 198, Short.MAX_VALUE));
        this.productTabbedPane.addTab(this.resourceBundle.getString("environmentPanel.TabConstraints.tabTitle"), this.environmentPanel);
        this.add((Component)this.productTabbedPane, "Center");
        this.aboutHeaderPanel.setBackground(new Color(255, 255, 255));
        this.aboutHeaderPanel.setLayout(new BorderLayout());
        this.aboutHeaderPanel.add((Component)this.headerSeparator, "South");
        this.aboutHeaderTitlePanel.setOpaque(false);
        this.appDescLabel.setForeground(Color.black);
        this.appDescLabel.setText(this.resourceBundle.getString("appDescLabel.text"));
        this.appTitleLabel.setFont(this.appTitleLabel.getFont().deriveFont(this.appTitleLabel.getFont().getStyle() | 1, this.appTitleLabel.getFont().getSize() + 4));
        this.appTitleLabel.setForeground(Color.black);
        this.appTitleLabel.setText(this.resourceBundle.getString("appTitleLabel.text"));
        GroupLayout aboutHeaderTitlePanelLayout = new GroupLayout(this.aboutHeaderTitlePanel);
        this.aboutHeaderTitlePanel.setLayout(aboutHeaderTitlePanelLayout);
        aboutHeaderTitlePanelLayout.setHorizontalGroup(aboutHeaderTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE).addGroup(aboutHeaderTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(aboutHeaderTitlePanelLayout.createSequentialGroup().addContainerGap().addGroup(aboutHeaderTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.appDescLabel, -1, -1, Short.MAX_VALUE).addComponent(this.appTitleLabel, -1, -1, Short.MAX_VALUE)).addContainerGap())));
        aboutHeaderTitlePanelLayout.setVerticalGroup(aboutHeaderTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 65, Short.MAX_VALUE).addGroup(aboutHeaderTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(aboutHeaderTitlePanelLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.appTitleLabel).addGap(7, 7, 7).addComponent(this.appDescLabel).addContainerGap(-1, Short.MAX_VALUE))));
        this.aboutHeaderPanel.add((Component)this.aboutHeaderTitlePanel, "Center");
        this.add((Component)this.aboutHeaderPanel, "First");
    }

    private void appHomepageLabelMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && !evt.isPopupTrigger()) {
            DesktopUtils.openDesktopURL((String)this.appHomepageLink);
        }
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new AboutPanel());
    }

    public void setSideComponent(JComponent sideComponent) {
        if (this.sideComponent != null) {
            this.remove(this.sideComponent);
        }
        if (sideComponent != null) {
            this.add((Component)sideComponent, "West");
            this.sideComponent = sideComponent;
        }
    }

    public void setApplication(XBApplication application) {
        this.appBundle = application != null ? application.getAppBundle() : this.resourceBundle;
        this.aboutModulesPanel.setApplication(application);
        this.aboutAuthorsPanel.setApplication(application);
        try {
            if (this.appBundle.containsKey("Application.licenseFile")) {
                String licenseFilePath = this.appBundle.getString("Application.licenseFile");
                this.licenseEditorPane.setPage(this.getClass().getResource(licenseFilePath));
            }
            this.licenseEditorPane.addHyperlinkListener(event -> {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    DesktopUtils.openDesktopURL((String)event.getURL().toExternalForm());
                }
            });
        }
        catch (IOException ex) {
            Logger.getLogger(AboutPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.nameTextField.setText(this.appBundle.getString("Application.name"));
        this.versionTextField.setText(this.appBundle.getString("Application.version"));
        this.vendorTextField.setText(this.appBundle.getString("Application.vendor"));
        this.licenseTextField.setText(this.appBundle.getString("Application.license"));
        this.appHomepageLink = this.appBundle.getString("Application.homepage");
        this.appHomepageLabel.setText("<html><a href=\"\">" + this.appHomepageLink + "</a></html>");
        if (this.appBundle.containsKey("Application.aboutImage")) {
            String aboutImagePath = this.appBundle.getString("Application.aboutImage");
            this.imageLabel.setIcon(new ImageIcon(this.getClass().getResource(aboutImagePath)));
            this.aboutHeaderPanel.add((Component)this.aboutHeaderImagePanel, "West");
        }
        this.appTitleLabel.setText(this.appBundle.getString("Application.title"));
        this.appDescLabel.setText(this.appBundle.getString("Application.description"));
        this.appHomepageLabel.setComponentPopupMenu(new JPopupMenu(){
            private boolean initialized = false;

            @Override
            public void show(Component invoker, int x, int y) {
                if (!this.initialized) {
                    DefaultPopupMenu.getInstance().appendLinkMenu((JPopupMenu)this, new LinkActionsHandler(){

                        public void performCopyLink() {
                            String targetURL = AboutPanel.this.appHomepageLink;
                            StringSelection stringSelection = new StringSelection(targetURL);
                            ClipboardUtils.getClipboard().setContents(stringSelection, stringSelection);
                        }

                        public void performOpenLink() {
                            String targetURL = AboutPanel.this.appHomepageLink;
                            DesktopUtils.openDesktopURL((String)targetURL);
                        }

                        public boolean isLinkSelected() {
                            return true;
                        }
                    });
                    this.initialized = true;
                }
                super.show(invoker, x, y);
            }
        });
    }
}

