/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class StreamUtils {
    private static final int BUFFER_SIZE = 1024;

    private StreamUtils() {
    }

    public static void copyInputStreamToOutputStream(InputStream source, OutputStream target) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        int bufferUsed = 0;
        do {
            if ((bytesRead = source.read(buffer, bufferUsed, 1024 - bufferUsed)) <= 0 || (bufferUsed += bytesRead) != 1024) continue;
            target.write(buffer, 0, 1024);
            bufferUsed = 0;
        } while (bytesRead > 0);
        if (bufferUsed > 0) {
            target.write(buffer, 0, bufferUsed);
        }
    }

    public static void copyInputStreamToOutputStream(InputStream source, OutputStream target, long maxAllowedSize) throws IOException {
        int bytesRead;
        long remain = maxAllowedSize;
        byte[] buffer = new byte[1024];
        int bufferUsed = 0;
        do {
            if ((bytesRead = source.read(buffer, bufferUsed, 1024 - bufferUsed)) <= 0) continue;
            if ((long)bytesRead > remain) {
                throw new IOException("More data than limited to " + maxAllowedSize + " available.");
            }
            remain -= (long)bytesRead;
            if ((bufferUsed += bytesRead) != 1024) continue;
            target.write(buffer, 0, 1024);
            bufferUsed = 0;
        } while (bytesRead > 0);
        if (bufferUsed > 0) {
            target.write(buffer, 0, bufferUsed);
        }
    }

    public static void copyFixedSizeInputStreamToOutputStream(InputStream source, OutputStream target, long size) throws IOException {
        int bytesRead;
        long remain = size;
        int bufferSize = size < 1024L ? (int)size : 1024;
        byte[] buffer = new byte[bufferSize];
        int bufferUsed = 0;
        do {
            if ((bytesRead = source.read(buffer, bufferUsed, bufferSize - bufferUsed)) <= 0 || (bufferUsed += bytesRead) != bufferSize) continue;
            target.write(buffer, 0, bufferSize);
            bufferUsed = 0;
            if ((remain -= (long)bufferSize) == 0L) break;
            int n = bufferSize = remain < 1024L ? (int)remain : 1024;
        } while (bytesRead > 0);
        if (bufferUsed > 0) {
            target.write(buffer, 0, bufferUsed);
            remain -= (long)bufferUsed;
        }
        if (remain > 0L) {
            throw new IOException("Unexpected data processed - " + size + " expected, " + (size - remain) + " processed.");
        }
    }

    public static void skipInputStreamData(InputStream source, long skipBytes) throws IOException {
        long skipped;
        while (skipBytes > 0L && (skipped = source.skip(skipBytes > 1024L ? 1024L : skipBytes)) > 0L) {
            skipBytes -= skipped;
        }
        if (skipBytes > 0L) {
            int toRead = skipBytes < 1024L ? (int)skipBytes : 1024;
            byte[] buffer = new byte[toRead];
            do {
                int bytesRead;
                if ((bytesRead = source.read(buffer, 0, toRead)) <= 0) {
                    throw new IOException("Unable to skip data");
                }
                int n = toRead = (skipBytes -= (long)bytesRead) < 1024L ? (int)skipBytes : 1024;
            } while (skipBytes > 0L);
        }
    }

    public static void copyInputStreamToTwoOutputStreams(InputStream source, OutputStream target, OutputStream secondTarget) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        int bufferUsed = 0;
        do {
            if ((bytesRead = source.read(buffer, bufferUsed, 1024 - bufferUsed)) <= 0 || (bufferUsed += bytesRead) != 1024) continue;
            target.write(buffer, 0, 1024);
            secondTarget.write(buffer, 0, 1024);
            bufferUsed = 0;
        } while (bytesRead > 0);
        if (bufferUsed > 0) {
            target.write(buffer, 0, bufferUsed);
            secondTarget.write(buffer, 0, bufferUsed);
        }
    }

    public static boolean compareStreams(InputStream stream, InputStream compStream) throws IOException {
        int nextByte;
        byte[] dataBlob = new byte[2];
        do {
            nextByte = stream.read(dataBlob, 0, 1);
            int compNextByte = compStream.read(dataBlob, 1, 1);
            if (nextByte < 0) {
                return compNextByte < 0;
            }
            if (compNextByte < 0) {
                return false;
            }
            if (dataBlob[0] == dataBlob[1]) continue;
            return false;
        } while (nextByte > 0);
        return true;
    }
}

