/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.ubnumber.type;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.ubnumber.UBNatural;
import org.exbin.xbup.core.ubnumber.exception.UBOverFlowException;

@ParametersAreNonnullByDefault
public class UBNat32
implements UBNatural,
XBPSequenceSerializable {
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    private long value;

    public UBNat32() {
        this.value = 0L;
    }

    public UBNat32(int value) {
        this.value = value;
    }

    public UBNat32(long value) {
        this.value = value;
    }

    public UBNat32(UBNatural nat) {
        this.value = nat.getLong();
    }

    @Override
    public void setValue(int value) throws UBOverFlowException {
        if (value < 0) {
            throw new UBOverFlowException("Can't set negative value to natural number");
        }
        this.value = value;
    }

    @Override
    public void setValue(long value) throws UBOverFlowException {
        if (value < 0L) {
            throw new UBOverFlowException("Can't set negative value to natural number");
        }
        if (value > 0xFFFFFFFFL) {
            throw new UBOverFlowException("Value too big");
        }
        this.value = value;
    }

    @Override
    public int getInt() throws UBOverFlowException {
        return (int)this.value;
    }

    @Override
    public long getLong() throws UBOverFlowException {
        return this.value;
    }

    @Override
    public boolean isZero() {
        return this.value == 0L;
    }

    @Override
    public long getSegmentCount() {
        return 1L;
    }

    @Override
    public long getValueSegment(long segmentIndex) {
        if (segmentIndex != 0L) {
            throw new IndexOutOfBoundsException();
        }
        return this.value;
    }

    public int hashCode() {
        return Long.valueOf(this.value).hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UBNat32 other = (UBNat32)obj;
        return this.value == other.value;
    }

    @Override
    public int fromStreamUB(InputStream stream) throws IOException, XBProcessingException {
        byte[] buf = new byte[1];
        this.readBuf(stream, buf);
        long input = (char)buf[0] & 0xFF;
        if (input < 128L) {
            this.value = input;
            return 1;
        }
        if (input < 192L) {
            this.value = (input & 0x3FL) << 8;
            this.readBuf(stream, buf);
            this.value += (long)((buf[0] & 0xFF) + 128);
            return 2;
        }
        if (input < 224L) {
            this.value = (input & 0x1FL) << 16;
            this.readBuf(stream, buf);
            this.value += (long)((buf[0] & 0xFF) << 8);
            this.readBuf(stream, buf);
            this.value += (long)((buf[0] & 0xFF) + 16512);
            return 3;
        }
        if (input < 240L) {
            this.value = (input & 0xFL) << 24;
            this.readBuf(stream, buf);
            this.value += (long)((buf[0] & 0xFF) << 16);
            this.readBuf(stream, buf);
            this.value += (long)((buf[0] & 0xFF) << 8);
            this.readBuf(stream, buf);
            this.value += (long)((buf[0] & 0xFF) + 2113664);
            return 4;
        }
        if (input < 248L) {
            this.value = (input & 7L) << 32;
            this.readBuf(stream, buf);
            this.value += (long)((buf[0] & 0xFF) << 24);
            this.readBuf(stream, buf);
            this.value += (long)((buf[0] & 0xFF) << 16);
            this.readBuf(stream, buf);
            this.value += (long)((buf[0] & 0xFF) << 8);
            this.readBuf(stream, buf);
            this.value += (long)((buf[0] & 0xFF) + 270549120);
            return 5;
        }
        throw new XBProcessingException("Value is too big for 32-bit value", XBProcessingExceptionType.UNSUPPORTED);
    }

    private void readBuf(InputStream stream, byte[] buf) throws IOException {
        if (stream.read(buf) < 0) {
            throw new XBProcessingException("End of data reached", XBProcessingExceptionType.UNEXPECTED_END_OF_STREAM);
        }
    }

    @Override
    public int toStreamUB(OutputStream stream) throws IOException {
        if (this.value < 128L) {
            stream.write((char)this.value);
            return 1;
        }
        if (this.value < 16512L) {
            byte[] out = new byte[2];
            long outValue = this.value - 128L;
            out[0] = (byte)((outValue >> 8) + 128L);
            out[1] = (byte)(outValue & 0xFFL);
            stream.write(out);
            return 2;
        }
        if (this.value < 2113664L) {
            long outValue = this.value - 16512L;
            byte[] out = new byte[]{(byte)((outValue >> 16) + 192L), (byte)(outValue >> 8 & 0xFFL), (byte)(outValue & 0xFFL)};
            stream.write(out);
            return 3;
        }
        if (this.value < 270549120L) {
            long outValue = this.value - 2113664L;
            byte[] out = new byte[]{(byte)((outValue >> 24) + 224L), (byte)(outValue >> 16 & 0xFFL), (byte)(outValue >> 8 & 0xFFL), (byte)(outValue & 0xFFL)};
            stream.write(out);
            return 4;
        }
        long outValue = this.value - 270549120L;
        byte[] out = new byte[]{(byte)((outValue >> 32) + 240L), (byte)(outValue >> 24 & 0xFFL), (byte)(outValue >> 16 & 0xFFL), (byte)(outValue >> 8 & 0xFFL), (byte)(outValue & 0xFFL)};
        stream.write(out);
        return 5;
    }

    @Override
    public int getSizeUB() {
        if (this.value < 128L) {
            return 1;
        }
        if (this.value < 16512L) {
            return 2;
        }
        if (this.value < 2113664L) {
            return 3;
        }
        if (this.value < 270549120L) {
            return 4;
        }
        return 5;
    }

    @Override
    public void serializeXB(XBPSequenceSerialHandler serial) throws XBProcessingException, IOException {
        serial.begin();
        serial.matchType(new XBDeclBlockType(XBUP_BLOCKREV_CATALOGPATH));
        serial.attribute(this);
        serial.end();
    }

    @Override
    public void setNaturalZero() {
        this.value = 0L;
    }

    @Override
    public void setNaturalInt(int intValue) throws UBOverFlowException {
        this.setValue(intValue);
    }

    @Override
    public void setNaturalLong(long longValue) throws UBOverFlowException {
        this.setValue(longValue);
    }

    @Override
    public void convertFromNatural(UBNatural natural) {
        this.setValue(natural.getLong());
    }

    @Override
    public boolean isNaturalZero() {
        return this.isZero();
    }

    @Override
    public int getNaturalInt() throws UBOverFlowException {
        return this.getInt();
    }

    @Override
    public long getNaturalLong() throws UBOverFlowException {
        return this.getLong();
    }

    @Override
    @Nonnull
    public UBNatural convertToNatural() {
        return this;
    }
}

