/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.type;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBTEmptyBlock;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.serial.param.XBPInputSerialHandler;
import org.exbin.xbup.core.serial.param.XBPOutputSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSerializable;

@ParametersAreNonnullByDefault
public class XBDateTime
implements XBPSerializable {
    private Date value;
    static long[] XBUP_BLOCKREV_CATALOGPATH = new long[]{0L, 0L, 14L, 0L};

    public XBDateTime() {
        this.value = new Date();
    }

    public XBDateTime(Date value) {
        this.value = value;
    }

    public Date getValue() {
        return this.value;
    }

    public void setValue(Date value) {
        this.value = value;
    }

    @Override
    public void serializeFromXB(XBPInputSerialHandler serial) throws XBProcessingException, IOException {
        if (serial.pullIfEmptyBlock()) {
            this.value = null;
        } else {
            serial.begin();
            serial.matchType(new XBDeclBlockType(XBUP_BLOCKREV_CATALOGPATH));
            int year = serial.pullIntAttribute();
            int month = serial.pullIntAttribute();
            int day = serial.pullIntAttribute();
            int hour = serial.pullIntAttribute();
            int minute = serial.pullIntAttribute();
            int second = serial.pullIntAttribute();
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.set(year, month, day, hour, minute, second);
            this.value = calendar.getTime();
            serial.end();
        }
    }

    @Override
    public void serializeToXB(XBPOutputSerialHandler serial) throws XBProcessingException, IOException {
        if (this.value == null) {
            serial.append(XBTEmptyBlock.getEmptyBlock());
        } else {
            serial.begin();
            serial.matchType(new XBDeclBlockType(XBUP_BLOCKREV_CATALOGPATH));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.value);
            serial.putAttribute(calendar.get(1));
            serial.putAttribute(calendar.get(2));
            serial.putAttribute(calendar.get(5));
            serial.putAttribute(calendar.get(11));
            serial.putAttribute(calendar.get(12));
            serial.putAttribute(calendar.get(13));
            serial.end();
        }
    }
}

