/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.serial.sequence;

import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBSerializationMode;
import org.exbin.xbup.core.serial.sequence.XBListConsistSerializable;
import org.exbin.xbup.core.type.XBString;
import org.exbin.xbup.core.ubnumber.UBENatural;
import org.exbin.xbup.core.ubnumber.type.UBENat32;

@ParametersAreNonnullByDefault
public class XBStringListConsistSerializable
implements XBListConsistSerializable {
    private int position = 0;
    private final List<String> values;

    public XBStringListConsistSerializable(List<String> values) {
        this.values = values;
    }

    @Override
    public UBENatural getSize() {
        return new UBENat32(this.values.size());
    }

    @Override
    public void setSize(UBENatural size) {
        block4: {
            int valuesSize;
            int intSize;
            block3: {
                if (size == null || size.isInfinity()) {
                    throw new InvalidParameterException("Specified size must be natural number");
                }
                intSize = size.getInt();
                if (intSize <= (valuesSize = this.values.size())) break block3;
                while (valuesSize < intSize) {
                    this.values.add(null);
                    ++valuesSize;
                }
                break block4;
            }
            if (intSize >= valuesSize) break block4;
            while (valuesSize > intSize) {
                this.values.remove(valuesSize - 1);
                --valuesSize;
            }
        }
    }

    @Override
    public void reset() {
        this.position = 0;
    }

    @Override
    @Nonnull
    public XBSerializable next() {
        return new ItemHandler(this.position++);
    }

    @ParametersAreNonnullByDefault
    private class ItemHandler
    implements XBPSequenceSerializable {
        private final int itemIndex;

        public ItemHandler(int itemIndex) {
            this.itemIndex = itemIndex;
        }

        @Override
        public void serializeXB(XBPSequenceSerialHandler serial) throws XBProcessingException, IOException {
            serial.begin();
            serial.matchType();
            if (serial.getSerializationMode() == XBSerializationMode.PULL) {
                XBString value = new XBString();
                serial.consist(value);
                XBStringListConsistSerializable.this.values.set(this.itemIndex, value.getValue());
            } else {
                serial.consist(new XBString((String)XBStringListConsistSerializable.this.values.get(this.itemIndex)));
            }
            serial.end();
        }
    }
}

