/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.serial.sequence;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.sequence.XBListConsistSerializable;
import org.exbin.xbup.core.serial.sequence.XBListJoinSerializable;
import org.exbin.xbup.core.serial.sequence.XBSerialSequenceItem;
import org.exbin.xbup.core.serial.sequence.XBSerialSequenceOp;

@ParametersAreNonnullByDefault
public class XBSerialSequence {
    @Nullable
    private XBBlockType type;
    @Nonnull
    private XBBlockTerminationMode terminationMode = XBBlockTerminationMode.SIZE_SPECIFIED;
    private List<XBSerialSequenceItem> items = new ArrayList<XBSerialSequenceItem>();

    public XBSerialSequence() {
    }

    public XBSerialSequence(XBBlockTerminationMode terminationMode) {
        this();
        this.terminationMode = terminationMode;
    }

    public XBSerialSequence(@Nullable XBBlockType type, XBBlockTerminationMode terminationMode) {
        this(terminationMode);
        this.type = type;
    }

    public XBSerialSequence(@Nullable XBBlockType type) {
        this(type, XBBlockTerminationMode.SIZE_SPECIFIED);
    }

    public void add(XBSerialSequenceOp op, XBSerializable item) {
        this.items.add(new XBSerialSequenceItem(op, item));
    }

    private void privateJoin(XBSerializable item) {
        this.items.add(new XBSerialSequenceItem(XBSerialSequenceOp.JOIN, item));
    }

    public void join(XBSerializable item) {
        this.privateJoin(item);
    }

    public void consist(XBSerializable item) {
        this.items.add(new XBSerialSequenceItem(XBSerialSequenceOp.CONSIST, item));
    }

    public void listJoin(XBListJoinSerializable item) {
        this.items.add(new XBSerialSequenceItem(XBSerialSequenceOp.LIST_JOIN, item));
    }

    public void listConsist(XBListConsistSerializable item) {
        this.items.add(new XBSerialSequenceItem(XBSerialSequenceOp.LIST_CONSIST, item));
    }

    @Nullable
    public XBBlockType getBlockType() {
        return this.type;
    }

    public void setBlockType(@Nullable XBBlockType type) {
        this.type = type;
    }

    @Nonnull
    public XBBlockTerminationMode getTerminationMode() {
        return this.terminationMode;
    }

    public void setTerminationMode(XBBlockTerminationMode terminationMode) {
        this.terminationMode = terminationMode;
    }

    @Nonnull
    public List<XBSerialSequenceItem> getItems() {
        return this.items;
    }

    public void setItems(List<XBSerialSequenceItem> items) {
        this.items.clear();
        this.items.addAll(items);
    }

    public void append(XBSerialSequence seq) {
        this.items.addAll(seq.items);
    }
}

