/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token.pull.convert;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBEndToken;
import org.exbin.xbup.core.parser.token.XBTAttributeToken;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTDataToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTokenType;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.parser.token.pull.XBPullProvider;
import org.exbin.xbup.core.parser.token.pull.XBTPullConsumer;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;

@ParametersAreNonnullByDefault
public class XBToXBTPullUnknownConvertor
implements XBPullProvider,
XBTPullConsumer {
    @Nonnull
    private XBTPullProvider pullProvider;
    @Nonnull
    private final XBFixedBlockType unknownBlockType = new XBFixedBlockType();

    public XBToXBTPullUnknownConvertor(XBTPullProvider pullProvider) {
        this.pullProvider = pullProvider;
    }

    @Override
    public void attachXBTPullProvider(XBTPullProvider pullProvider) {
        this.pullProvider = pullProvider;
    }

    @Override
    @Nonnull
    public XBToken pullXBToken() throws XBProcessingException, IOException {
        XBTToken token = this.pullProvider.pullXBTToken();
        if (token.getTokenType() == XBTTokenType.TYPE) {
            if (!this.unknownBlockType.equals(((XBTTypeToken)token).getBlockType())) {
                throw new XBProcessingException("Unexpected token type - Unknown type expected", XBProcessingExceptionType.BLOCK_TYPE_MISMATCH);
            }
            token = this.pullProvider.pullXBTToken();
        }
        switch (token.getTokenType()) {
            case BEGIN: {
                return XBBeginToken.create(((XBTBeginToken)token).getTerminationMode());
            }
            case ATTRIBUTE: {
                return XBAttributeToken.create(((XBTAttributeToken)token).getAttribute());
            }
            case DATA: {
                return XBDataToken.create(((XBTDataToken)token).getData());
            }
            case END: {
                return XBEndToken.create();
            }
        }
        throw new XBProcessingException("Unexpected token type", XBProcessingExceptionType.UNKNOWN);
    }
}

