/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token.pull.convert;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.parser.token.pull.XBPullFilter;
import org.exbin.xbup.core.parser.token.pull.XBPullProvider;

@ParametersAreNonnullByDefault
public class XBPrintPullFilter
implements XBPullFilter {
    @Nonnull
    private XBPullProvider pullProvider;
    @Nonnull
    private String prefix = "";

    public XBPrintPullFilter(String prefix, XBPullProvider pullProvider) {
        this(pullProvider);
        this.prefix = prefix;
    }

    public XBPrintPullFilter(XBPullProvider pullProvider) {
        this.pullProvider = pullProvider;
    }

    @Override
    @Nonnull
    public XBToken pullXBToken() throws XBProcessingException, IOException {
        XBToken token = this.pullProvider.pullXBToken();
        switch (token.getTokenType()) {
            case BEGIN: {
                System.out.println(this.prefix + "> Begin (" + ((XBBeginToken)token).getTerminationMode().toString() + "):");
                break;
            }
            case ATTRIBUTE: {
                System.out.println(this.prefix + "  Attribute: " + ((XBAttributeToken)token).getAttribute().getNaturalLong());
                break;
            }
            case DATA: {
                System.out.println(this.prefix + "  Data:" + ((XBDataToken)token).getData().available());
                break;
            }
            case END: {
                System.out.println(this.prefix + "< End.");
                break;
            }
            default: {
                throw new XBProcessingException("Unexpected token type", XBProcessingExceptionType.UNKNOWN);
            }
        }
        return token;
    }

    @Override
    public void attachXBPullProvider(XBPullProvider pullProvider) {
        this.pullProvider = pullProvider;
    }
}

