/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token.event.convert;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBTAttributeToken;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTDataToken;
import org.exbin.xbup.core.parser.token.XBTEndToken;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.parser.token.event.XBEventListener;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.parser.token.event.XBTEventProducer;

@ParametersAreNonnullByDefault
public class XBToXBTEventWrapper
implements XBEventListener,
XBTEventProducer {
    @Nonnull
    private XBTEventListener eventListener;
    private final XBFixedBlockType unknownBlockType = new XBFixedBlockType();
    private boolean typeSent = false;

    public XBToXBTEventWrapper(XBTEventListener eventListener) {
        this.eventListener = eventListener;
    }

    @Override
    public void attachXBTEventListener(XBTEventListener eventListener) {
        this.eventListener = eventListener;
        this.typeSent = false;
    }

    @Override
    public void putXBToken(XBToken token) throws XBProcessingException, IOException {
        switch (token.getTokenType()) {
            case BEGIN: {
                this.typeSent = false;
                this.eventListener.putXBTToken(XBTBeginToken.create(((XBBeginToken)token).getTerminationMode()));
                break;
            }
            case ATTRIBUTE: {
                if (!this.typeSent) {
                    this.eventListener.putXBTToken(XBTTypeToken.create(this.unknownBlockType));
                    this.typeSent = true;
                }
                this.eventListener.putXBTToken(XBTAttributeToken.create(((XBAttributeToken)token).getAttribute()));
                break;
            }
            case DATA: {
                this.eventListener.putXBTToken(XBTDataToken.create(((XBDataToken)token).getData()));
                break;
            }
            case END: {
                this.eventListener.putXBTToken(XBTEndToken.create());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected token type " + token.getTokenType().toString());
            }
        }
    }
}

