/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token.event.convert;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.parser.token.event.XBEventFilter;
import org.exbin.xbup.core.parser.token.event.XBEventListener;

@ParametersAreNonnullByDefault
public class XBPrintEventFilter
implements XBEventFilter {
    @Nonnull
    private XBEventListener eventListener;
    @Nonnull
    private String prefix = "";

    public XBPrintEventFilter(String prefix, XBEventListener eventListener) {
        this(eventListener);
        this.prefix = prefix;
    }

    public XBPrintEventFilter(XBEventListener eventListener) {
        this.eventListener = eventListener;
    }

    @Override
    public void putXBToken(XBToken token) throws XBProcessingException, IOException {
        switch (token.getTokenType()) {
            case BEGIN: {
                System.out.println(this.prefix + "> Begin (" + ((XBBeginToken)token).getTerminationMode().toString() + "):");
                break;
            }
            case ATTRIBUTE: {
                System.out.println(this.prefix + "  Attribute: " + ((XBAttributeToken)token).getAttribute().getNaturalLong());
                break;
            }
            case DATA: {
                System.out.println(this.prefix + "  Data:" + ((XBDataToken)token).getData().available());
                break;
            }
            case END: {
                System.out.println(this.prefix + "< End.");
                break;
            }
            default: {
                throw new XBProcessingException("Unexpected token type", XBProcessingExceptionType.UNKNOWN);
            }
        }
        if (this.eventListener != null) {
            this.eventListener.putXBToken(token);
        }
    }

    @Override
    public void attachXBEventListener(XBEventListener eventListener) {
        this.eventListener = eventListener;
    }
}

