/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.basic.wrapper;

import java.io.IOException;
import java.io.OutputStream;
import org.exbin.xbup.core.stream.FinishableStream;

public class FixedDataOutputStreamWrapper
extends OutputStream
implements FinishableStream {
    private final OutputStream stream;
    private int remaining = 0;
    private int length = 0;

    public FixedDataOutputStreamWrapper(OutputStream stream, int fixedLength) throws IOException {
        this.stream = stream;
        this.remaining = fixedLength;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.remaining > 0) {
            this.stream.write(b);
            --this.remaining;
            ++this.length;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b.length < this.remaining) {
            this.stream.write(b, 0, b.length);
            this.remaining -= b.length;
            this.length += b.length;
        } else {
            throw new IOException("Attempt to write more data than specified");
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len < this.remaining) {
            this.stream.write(b, off, len);
            this.remaining -= len;
            this.length += len;
        } else {
            throw new IOException("Attempt to write more data than specified");
        }
    }

    @Override
    public long finish() throws IOException {
        if (this.remaining > 0) {
            this.write(0);
        }
        return this.length;
    }

    @Override
    public long getLength() {
        return this.length;
    }
}

