/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.catalog;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public enum XBPlugUiType {
    COMPONENT_VIEWER(1, "Component Viewer"),
    COMPONENT_EDITOR(2, "Component Editor"),
    PANEL_VIEWER(3, "Panel Viewer"),
    PANEL_EDITOR(4, "Panel Editor"),
    ROW_EDITOR(5, "Row Editor");

    private final int dbIndex;
    private final String name;

    private XBPlugUiType(int dbIndex, String name) {
        this.dbIndex = dbIndex;
        this.name = name;
    }

    public int getDbIndex() {
        return this.dbIndex;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public static XBPlugUiType findByDbIndex(int dbIndex) {
        for (XBPlugUiType type : XBPlugUiType.values()) {
            if (type.getDbIndex() != dbIndex) continue;
            return type;
        }
        throw new IllegalArgumentException("No type match given DB index");
    }
}

