/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.block.declaration.local;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.exbin.xbup.core.block.XBBasicBlockType;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.declaration.XBGroupDecl;
import org.exbin.xbup.core.block.definition.XBGroupDef;
import org.exbin.xbup.core.block.definition.XBGroupParam;
import org.exbin.xbup.core.block.definition.XBGroupParamConsist;
import org.exbin.xbup.core.block.definition.XBGroupParamJoin;
import org.exbin.xbup.core.block.definition.local.XBLGroupDef;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBTListener;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.serial.basic.XBReceivingFinished;
import org.exbin.xbup.core.serial.basic.XBTBasicInputReceivingSerialHandler;
import org.exbin.xbup.core.serial.basic.XBTBasicOutputReceivingSerialHandler;
import org.exbin.xbup.core.serial.basic.XBTBasicReceivingSerializable;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBSerializationMode;

public class XBLGroupDecl
implements XBGroupDecl,
XBPSequenceSerializable,
XBTBasicReceivingSerializable {
    private long[] catalogPath = null;
    private int revision;
    private XBGroupDef groupDef = null;

    public XBLGroupDecl() {
        this.catalogPath = null;
        this.revision = 0;
    }

    public XBLGroupDecl(long[] revisionPath) {
        this.revision = (int)revisionPath[revisionPath.length - 1];
        this.catalogPath = Arrays.copyOf(revisionPath, revisionPath.length - 1);
    }

    public XBLGroupDecl(Long[] revisionPath) {
        this.setCatalogObjectPath(Arrays.copyOf(revisionPath, revisionPath.length - 1));
        this.revision = revisionPath[revisionPath.length - 1].intValue();
    }

    public XBLGroupDecl(long[] specPath, int revision) {
        this.catalogPath = specPath;
        this.revision = revision;
    }

    public XBLGroupDecl(Long[] specPath, int revision) {
        this.setCatalogObjectPath(specPath);
        this.revision = revision;
    }

    public XBLGroupDecl(XBLGroupDef groupDef) {
        this.groupDef = groupDef;
    }

    public XBLGroupDecl(XBBlockDecl block) {
        this.groupDef = new XBLGroupDef(block);
    }

    private void setCatalogObjectPath(Long[] path) {
        this.catalogPath = new long[path.length];
        for (int i = 0; i < path.length; ++i) {
            this.catalogPath[i] = path[i];
        }
    }

    @Override
    public List<XBBlockDecl> getBlockDecls() {
        ArrayList<XBBlockDecl> blocks = new ArrayList<XBBlockDecl>();
        int blocksLimit = this.getBlocksLimit();
        for (int paramIndex = 0; paramIndex < blocksLimit; ++paramIndex) {
            XBGroupParam groupParam = this.groupDef.getGroupParam(paramIndex);
            if (groupParam instanceof XBGroupParamJoin) {
                XBGroupDecl groupDecl = ((XBGroupParamJoin)groupParam).getGroupDecl();
                blocks.addAll(groupDecl.getBlockDecls());
                continue;
            }
            blocks.add(((XBGroupParamConsist)groupParam).getBlockDecl());
        }
        return blocks;
    }

    public int getBlocksLimit() {
        return this.groupDef.getRevisionDef().getRevisionLimit(this.revision);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Arrays.hashCode(this.catalogPath);
        hash = 47 * hash + this.revision;
        return hash;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof XBLGroupDecl) {
            return Arrays.equals(((XBLGroupDecl)obj).catalogPath, this.catalogPath) && ((XBLGroupDecl)obj).revision == this.revision;
        }
        if (obj instanceof XBGroupDecl) {
            return obj.equals(this);
        }
        return super.equals(obj);
    }

    public void clear() {
        this.catalogPath = null;
        this.revision = 0;
        this.groupDef = null;
    }

    @Override
    public void serializeXB(XBPSequenceSerialHandler serial) throws XBProcessingException, IOException {
        serial.begin();
        serial.matchType(new XBFixedBlockType(XBBasicBlockType.GROUP_DECLARATION));
        if (serial.getSerializationMode() == XBSerializationMode.PULL) {
            this.catalogPath = new long[serial.pullAttribute().getNaturalInt()];
            for (int pathPosition = 0; pathPosition < this.catalogPath.length; ++pathPosition) {
                this.catalogPath[pathPosition] = serial.pullLongAttribute();
            }
            this.revision = serial.pullAttribute().getNaturalInt();
            if (!serial.pullIfEmptyBlock()) {
                this.groupDef = new XBLGroupDef();
                serial.pullConsist(this.groupDef);
            }
        } else {
            if (this.catalogPath != null) {
                serial.putAttribute(this.catalogPath.length);
                for (long pathIndex : this.catalogPath) {
                    serial.putAttribute(pathIndex);
                }
            } else {
                serial.putAttribute(0);
            }
            serial.putAttribute(this.revision);
            if (this.groupDef != null) {
                serial.putConsist(this.groupDef);
            }
        }
        serial.end();
    }

    @Override
    public void serializeRecvFromXB(XBTBasicInputReceivingSerialHandler serializationHandler) throws XBProcessingException, IOException {
        this.clear();
        serializationHandler.process(new RecvSerialization());
    }

    @Override
    public void serializeRecvToXB(XBTBasicOutputReceivingSerialHandler serializationHandler) throws XBProcessingException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long[] getCatalogPath() {
        return this.catalogPath;
    }

    public void setCatalogPath(long[] catalogPath) {
        this.catalogPath = catalogPath;
    }

    public void setCatalogPath(Long[] path) {
        this.setCatalogObjectPath(path);
    }

    @Override
    public XBGroupDef getGroupDef() {
        return this.groupDef;
    }

    public void setGroupDef(XBGroupDef groupDef) {
        this.groupDef = groupDef;
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    static /* synthetic */ long[] access$302(XBLGroupDecl x0, long[] x1) {
        x0.catalogPath = x1;
        return x1;
    }

    private class RecvSerialization
    implements XBTListener,
    XBReceivingFinished {
        private RecvProcessingState processingState = RecvProcessingState.START;
        private XBTListener activeListener = null;
        private int catalogPathPos = 0;

        private RecvSerialization() {
        }

        @Override
        public void beginXBT(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
            if (this.processingState == RecvProcessingState.TYPE || this.processingState == RecvProcessingState.CATALOG_PATH || this.processingState == RecvProcessingState.CATALOG_PATH_SIZE || this.processingState == RecvProcessingState.REVISION) {
                this.finishCatalogPath();
                XBLGroupDecl.this.groupDef = new XBLGroupDef();
                ((XBLGroupDef)XBLGroupDecl.this.groupDef).serializeRecvFromXB(new XBTBasicInputReceivingSerialHandler(){

                    @Override
                    public void process(XBTListener listener) {
                        RecvSerialization.this.activeListener = listener;
                    }
                });
            }
            if (this.activeListener != null) {
                this.activeListener.beginXBT(terminationMode);
                return;
            }
            if (this.processingState != RecvProcessingState.START) {
                throw new XBProcessingException("Unexpected token: begin", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
            this.processingState = RecvProcessingState.BEGIN;
        }

        @Override
        public void typeXBT(XBBlockType type) throws XBProcessingException, IOException {
            if (this.activeListener != null) {
                this.activeListener.typeXBT(type);
                return;
            }
            if (this.processingState != RecvProcessingState.BEGIN) {
                throw new XBProcessingException("Unexpected token: type", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
            this.processingState = RecvProcessingState.TYPE;
        }

        @Override
        public void attribXBT(XBAttribute value) throws XBProcessingException, IOException {
            if (this.activeListener != null) {
                this.activeListener.attribXBT(value);
                return;
            }
            if (this.processingState == RecvProcessingState.TYPE) {
                XBLGroupDecl.access$302(XBLGroupDecl.this, new long[value.getNaturalInt()]);
                this.catalogPathPos = 0;
                this.processingState = RecvProcessingState.CATALOG_PATH_SIZE;
            } else if (this.processingState == RecvProcessingState.CATALOG_PATH_SIZE) {
                ((XBLGroupDecl)XBLGroupDecl.this).catalogPath[this.catalogPathPos] = value.getNaturalLong();
                ++this.catalogPathPos;
                if (this.catalogPathPos == XBLGroupDecl.this.catalogPath.length) {
                    this.processingState = RecvProcessingState.CATALOG_PATH;
                }
            } else if (this.processingState == RecvProcessingState.CATALOG_PATH) {
                XBLGroupDecl.this.revision = value.getNaturalInt();
                this.processingState = RecvProcessingState.REVISION;
            } else {
                throw new XBProcessingException("Unexpected token: attribute", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
        }

        @Override
        public void dataXBT(InputStream data) throws XBProcessingException, IOException {
            if (this.activeListener != null) {
                this.activeListener.dataXBT(data);
                return;
            }
            throw new XBProcessingException("Unexpected token: data", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }

        @Override
        public void endXBT() throws XBProcessingException, IOException {
            if (this.activeListener != null) {
                this.activeListener.endXBT();
                if (((XBReceivingFinished)((Object)this.activeListener)).isFinished()) {
                    this.processingState = RecvProcessingState.GROUP_DEFINITION;
                    this.activeListener = null;
                }
                return;
            }
            if (this.processingState == RecvProcessingState.START || this.processingState == RecvProcessingState.BEGIN || this.processingState == RecvProcessingState.END) {
                throw new XBProcessingException("Unexpected token: end", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
            this.finishCatalogPath();
            this.processingState = RecvProcessingState.END;
        }

        private void finishCatalogPath() {
            if (this.processingState == RecvProcessingState.CATALOG_PATH_SIZE) {
                for (int i = this.catalogPathPos; i < XBLGroupDecl.this.catalogPath.length; ++i) {
                    ((XBLGroupDecl)XBLGroupDecl.this).catalogPath[i] = 0L;
                }
            }
        }

        @Override
        public boolean isFinished() {
            return this.processingState == RecvProcessingState.END;
        }
    }

    private static enum RecvProcessingState {
        START,
        BEGIN,
        TYPE,
        CATALOG_PATH_SIZE,
        CATALOG_PATH,
        REVISION,
        GROUP_DEFINITION,
        END;

    }
}

