/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.block.declaration;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBasicBlockType;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBDBlockType;
import org.exbin.xbup.core.block.XBFBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.declaration.XBContext;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.block.declaration.XBFormatDecl;
import org.exbin.xbup.core.block.declaration.XBGroup;
import org.exbin.xbup.core.block.declaration.XBGroupDecl;
import org.exbin.xbup.core.block.declaration.XBTypeConvertor;
import org.exbin.xbup.core.block.declaration.catalog.XBCFormatDecl;
import org.exbin.xbup.core.block.declaration.local.XBLFormatDecl;
import org.exbin.xbup.core.block.declaration.local.XBLGroupDecl;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBTListener;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.basic.XBReceivingFinished;
import org.exbin.xbup.core.serial.basic.XBTBasicInputReceivingSerialHandler;
import org.exbin.xbup.core.serial.basic.XBTBasicOutputReceivingSerialHandler;
import org.exbin.xbup.core.serial.basic.XBTBasicReceivingSerializable;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBSerializationMode;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

@ParametersAreNonnullByDefault
public class XBDeclaration
implements XBPSequenceSerializable,
XBTBasicReceivingSerializable,
XBTypeConvertor {
    private XBDeclaration parent = null;
    private XBFormatDecl formatDecl;
    private XBSerializable rootBlock;
    private boolean headerMode = false;
    private UBNat32 groupsReserved = new UBNat32(0);
    private UBNat32 preserveCount = new UBNat32(0);

    public XBDeclaration() {
        this(new XBLFormatDecl());
    }

    public XBDeclaration(XBFormatDecl formatDecl, @Nullable XBSerializable rootBlock) {
        this.formatDecl = formatDecl;
        this.rootBlock = rootBlock;
    }

    public XBDeclaration(XBFormatDecl format) {
        this(format, null);
    }

    public XBDeclaration(XBGroupDecl groupDecl, @Nullable XBSerializable rootBlock) {
        this(new XBLFormatDecl(groupDecl), rootBlock);
    }

    public XBDeclaration(XBGroupDecl group) {
        this(group, null);
    }

    public XBDeclaration(XBBlockDecl blockDecl, @Nullable XBSerializable rootBlock) {
        this(new XBLGroupDecl(blockDecl), rootBlock);
    }

    public XBDeclaration(XBBlockDecl blockDecl) {
        this(blockDecl, null);
    }

    public XBContext generateContext() {
        return this.generateContext((XBTypeConvertor)null);
    }

    public XBContext generateContext(@Nullable XBCatalog catalog) {
        return this.generateContext(null, catalog);
    }

    public XBContext generateContext(@Nullable XBTypeConvertor parentContext) {
        return this.generateContext(parentContext, null);
    }

    public XBContext generateContext(@Nullable XBTypeConvertor parentContext, @Nullable XBCatalog catalog) {
        XBFormatDecl catalogFormatDecl;
        XBContext context = new XBContext();
        context.setParent(parentContext);
        context.setStartFrom(this.preserveCount.getInt() + 1);
        List<XBGroup> groups = context.getGroups();
        XBFormatDecl decl = this.formatDecl;
        if (decl instanceof XBLFormatDecl && catalog != null && ((XBLFormatDecl)decl).getFormatDef() == null && (catalogFormatDecl = catalog.findFormatTypeByPath(((XBLFormatDecl)decl).getCatalogPathAsClassArray(), (int)decl.getRevision())) != null) {
            decl = catalogFormatDecl;
        }
        if (decl != null) {
            List<XBGroupDecl> formatGroups = decl.getGroupDecls();
            for (XBGroupDecl formatGroup : formatGroups) {
                groups.add(XBDeclaration.convertCatalogGroup(formatGroup, catalog));
            }
        }
        return context;
    }

    @Nullable
    public static XBGroup convertCatalogGroup(XBGroupDecl groupDecl) {
        return XBDeclaration.convertCatalogGroup(groupDecl, null);
    }

    @Nullable
    public static XBGroup convertCatalogGroup(@Nullable XBGroupDecl groupDecl, @Nullable XBCatalog catalog) {
        if (groupDecl == null) {
            return null;
        }
        XBGroup group = new XBGroup();
        group.getBlocks().addAll(groupDecl.getBlockDecls());
        return group;
    }

    public long getGroupsCount() {
        return this.preserveCount.getLong() + this.groupsReserved.getLong() + 1L;
    }

    @Override
    @Nullable
    public XBDeclBlockType getDeclBlockType(XBFBlockType fixedType) {
        XBGroup group = this.getGroupForId(0);
        if (group != null) {
            XBBlockDecl blockDecl = group.getBlockForId(fixedType.getBlockID().getInt());
            return blockDecl != null ? new XBDeclBlockType(blockDecl) : null;
        }
        return null;
    }

    @Override
    @Nullable
    public XBFixedBlockType getFixedBlockType(XBDBlockType declType) {
        return this.getFixedBlockType(declType.getBlockDecl(), -1);
    }

    @Override
    @Nullable
    public XBFixedBlockType getFixedBlockType(XBBlockDecl blockDecl, int groupIdLimit) {
        int groupId = 0;
        while ((long)groupId < this.getGroupsCount()) {
            XBGroup group = this.getGroupForId(groupId);
            if (group != null) {
                int blockId = 0;
                for (XBBlockDecl matchedDecl : group.getBlocks()) {
                    if (matchedDecl.equals(blockDecl)) {
                        return new XBFixedBlockType(groupId, blockId);
                    }
                    ++blockId;
                }
            }
            ++groupId;
        }
        return null;
    }

    @Override
    @Nullable
    public XBGroup getGroupForId(int groupId) {
        XBFormatDecl decl = this.formatDecl;
        if (groupId == 0) {
            return null;
        }
        if (groupId <= this.preserveCount.getInt() && this.parent != null) {
            return this.parent.getGroupForId(groupId);
        }
        if (groupId > this.preserveCount.getInt() && groupId < this.preserveCount.getInt() + this.groupsReserved.getInt() + 1 && decl != null) {
            if (decl instanceof XBLFormatDecl) {
                if (groupId - this.preserveCount.getInt() - 1 >= ((XBLFormatDecl)decl).getGroupDecls().size()) {
                    return null;
                }
                return new XBGroup(((XBLFormatDecl)decl).getGroupDecls().get(groupId - this.preserveCount.getInt() - 1).getBlockDecls());
            }
            if (decl instanceof XBCFormatDecl) {
                if (groupId - this.preserveCount.getInt() - 1 >= ((XBCFormatDecl)decl).getGroupDecls().size()) {
                    return null;
                }
                return new XBGroup(((XBCFormatDecl)decl).getGroupDecls().get(groupId - this.preserveCount.getInt() - 1).getBlockDecls());
            }
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return null;
    }

    @Override
    public void serializeXB(XBPSequenceSerialHandler serializationHandler) throws XBProcessingException, IOException {
        serializationHandler.begin();
        serializationHandler.matchType(new XBFixedBlockType(XBBasicBlockType.DECLARATION));
        serializationHandler.attribute(this.groupsReserved);
        serializationHandler.attribute(this.preserveCount);
        if (serializationHandler.getSerializationMode() == XBSerializationMode.PULL) {
            if (!serializationHandler.pullIfEmptyBlock()) {
                if (this.formatDecl == null) {
                    this.formatDecl = new XBLFormatDecl();
                }
                serializationHandler.consist(this.formatDecl);
            } else {
                this.formatDecl = null;
            }
            if (!this.headerMode) {
                serializationHandler.consist(this.rootBlock);
            }
        } else {
            serializationHandler.consist(this.formatDecl);
            if (!this.headerMode) {
                serializationHandler.consist(this.rootBlock);
            }
        }
        if (!this.headerMode) {
            serializationHandler.end();
        }
    }

    @Nonnull
    public XBFormatDecl getFormat() {
        return this.formatDecl;
    }

    public void setFormat(XBFormatDecl format) {
        this.formatDecl = format;
    }

    public int getGroupsReserved() {
        return this.groupsReserved.getInt();
    }

    public void setGroupsReserved(int groupsReserved) {
        this.groupsReserved = new UBNat32(groupsReserved);
    }

    public int getPreserveCount() {
        return this.preserveCount.getInt();
    }

    public void setPreserveCount(int preserveCount) {
        this.preserveCount = new UBNat32(preserveCount);
    }

    @Nullable
    public XBSerializable getRootBlock() {
        return this.rootBlock;
    }

    public void setRootBlock(@Nullable XBSerializable rootNode) {
        this.rootBlock = rootNode;
    }

    @Nullable
    public XBDeclaration getParent() {
        return this.parent;
    }

    public void setParent(@Nullable XBDeclaration parent) {
        this.parent = parent;
    }

    public void realignReservation(@Nullable XBCatalog catalog) {
        XBFormatDecl catalogFormatDecl;
        XBFormatDecl decl = this.formatDecl;
        if (this.formatDecl.getFormatDef() == null && catalog != null && this.formatDecl instanceof XBLFormatDecl && (catalogFormatDecl = catalog.findFormatTypeByPath(((XBLFormatDecl)this.formatDecl).getCatalogPathAsClassArray(), (int)this.formatDecl.getRevision())) != null) {
            decl = catalogFormatDecl;
        }
        this.groupsReserved = new UBNat32(decl.getGroupDecls().size());
    }

    public boolean isHeaderMode() {
        return this.headerMode;
    }

    public void setHeaderMode(boolean headerMode) {
        this.headerMode = headerMode;
    }

    @Override
    public void serializeRecvFromXB(XBTBasicInputReceivingSerialHandler serializationHandler) throws XBProcessingException, IOException {
        serializationHandler.process(new RecvSerialization());
    }

    @Override
    public void serializeRecvToXB(XBTBasicOutputReceivingSerialHandler serializationHandler) throws XBProcessingException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @ParametersAreNonnullByDefault
    private class RecvSerialization
    implements XBTListener,
    XBReceivingFinished {
        private RecvProcessingState processingState = RecvProcessingState.START;
        private XBTListener activeListener = null;

        private RecvSerialization() {
        }

        @Override
        public void beginXBT(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
            if (this.processingState == RecvProcessingState.GROUPS_RESERVED || this.processingState == RecvProcessingState.PRESERVE_COUNT) {
                if (XBDeclaration.this.formatDecl == null) {
                    XBDeclaration.this.formatDecl = new XBLFormatDecl();
                }
                ((XBTBasicReceivingSerializable)((Object)XBDeclaration.this.formatDecl)).serializeRecvFromXB(new XBTBasicInputReceivingSerialHandler(){

                    @Override
                    public void process(XBTListener listener) {
                        RecvSerialization.this.activeListener = listener;
                    }
                });
                this.processingState = RecvProcessingState.PRESERVE_COUNT;
            } else if (this.processingState == RecvProcessingState.FORMAT_DECLARATION) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            if (this.activeListener != null) {
                this.activeListener.beginXBT(terminationMode);
                return;
            }
            if (this.processingState == RecvProcessingState.BEGIN) {
                throw new XBProcessingException("Unexpected token: begin", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
            this.processingState = RecvProcessingState.BEGIN;
        }

        @Override
        public void typeXBT(XBBlockType type) throws XBProcessingException, IOException {
            if (this.activeListener != null) {
                this.activeListener.typeXBT(type);
                return;
            }
            if (this.processingState != RecvProcessingState.BEGIN) {
                throw new XBProcessingException("Unexpected token: type", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
            this.processingState = RecvProcessingState.TYPE;
        }

        @Override
        public void attribXBT(XBAttribute value) throws XBProcessingException, IOException {
            if (this.activeListener != null) {
                this.activeListener.attribXBT(value);
                return;
            }
            if (null != this.processingState) {
                switch (this.processingState) {
                    case TYPE: {
                        XBDeclaration.this.groupsReserved.setValue(value.getNaturalLong());
                        this.processingState = RecvProcessingState.GROUPS_RESERVED;
                        break;
                    }
                    case GROUPS_RESERVED: {
                        XBDeclaration.this.preserveCount.setValue(value.getNaturalLong());
                        this.processingState = RecvProcessingState.PRESERVE_COUNT;
                        break;
                    }
                    default: {
                        throw new XBProcessingException("Unexpected token: attribute", XBProcessingExceptionType.UNEXPECTED_ORDER);
                    }
                }
            }
        }

        @Override
        public void dataXBT(InputStream data) throws XBProcessingException, IOException {
            if (this.activeListener != null) {
                this.activeListener.dataXBT(data);
                return;
            }
            throw new XBProcessingException("Unexpected token: data", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }

        @Override
        public void endXBT() throws XBProcessingException, IOException {
            if (this.activeListener != null) {
                this.activeListener.endXBT();
                if (((XBReceivingFinished)((Object)this.activeListener)).isFinished()) {
                    if (this.processingState == RecvProcessingState.PRESERVE_COUNT) {
                        this.activeListener = null;
                        this.processingState = RecvProcessingState.FORMAT_DECLARATION;
                    } else {
                        this.processingState = RecvProcessingState.ROOT_NODE;
                        this.activeListener = null;
                    }
                }
                return;
            }
            this.processingState = RecvProcessingState.END;
        }

        @Override
        public boolean isFinished() {
            return this.processingState == RecvProcessingState.END || this.processingState == RecvProcessingState.FORMAT_DECLARATION && XBDeclaration.this.headerMode;
        }
    }

    private static enum RecvProcessingState {
        START,
        BEGIN,
        TYPE,
        GROUPS_RESERVED,
        PRESERVE_COUNT,
        FORMAT_DECLARATION,
        ROOT_NODE,
        END;

    }
}

