/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.block.declaration;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBDBlockType;
import org.exbin.xbup.core.block.XBFBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.block.declaration.XBGroup;
import org.exbin.xbup.core.block.declaration.XBTypeConvertor;

@ParametersAreNonnullByDefault
public class XBContext
implements XBTypeConvertor {
    private XBTypeConvertor parent = null;
    private int startFrom = 1;
    private List<XBGroup> groups = new ArrayList<XBGroup>();

    @Override
    @Nullable
    public XBGroup getGroupForId(int groupId) {
        if (groupId < this.startFrom) {
            return this.parent != null ? this.parent.getGroupForId(groupId) : null;
        }
        if (groupId - this.startFrom < this.groups.size()) {
            return this.groups.get(groupId - this.startFrom);
        }
        return null;
    }

    @Override
    @Nullable
    public XBDeclBlockType getDeclBlockType(XBFBlockType blockType) {
        XBGroup group = this.getGroupForId(blockType.getGroupID().getInt());
        return group != null ? new XBDeclBlockType(group.getBlockForId(blockType.getBlockID().getInt())) : null;
    }

    @Override
    @Nullable
    public XBFixedBlockType getFixedBlockType(XBDBlockType declType) {
        return this.getFixedBlockType(declType.getBlockDecl(), this.startFrom + this.groups.size() - 1);
    }

    @Override
    @Nullable
    public XBFixedBlockType getFixedBlockType(XBBlockDecl blockDecl, int groupIdLimit) {
        for (int groupIndex = 0; groupIndex <= groupIdLimit - this.startFrom; ++groupIndex) {
            XBGroup group = this.groups.get(groupIndex);
            List<XBBlockDecl> blocks = group.getBlocks();
            for (int blockIndex = 0; blockIndex < blocks.size(); ++blockIndex) {
                XBBlockDecl groupBlockDecl = blocks.get(blockIndex);
                if (!groupBlockDecl.equals(blockDecl)) continue;
                return new XBFixedBlockType(groupIndex + this.startFrom, blockIndex);
            }
        }
        return this.startFrom > 0 && this.parent != null ? this.parent.getFixedBlockType(blockDecl, this.startFrom - 1) : null;
    }

    @Nullable
    public XBTypeConvertor getParent() {
        return this.parent;
    }

    public void setParent(@Nullable XBTypeConvertor parent) {
        this.parent = parent;
    }

    public int getStartFrom() {
        return this.startFrom;
    }

    public void setStartFrom(int startFrom) {
        this.startFrom = startFrom;
    }

    @Nonnull
    public List<XBGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(List<XBGroup> groups) {
        this.groups = groups;
    }

    public int getGroupsCount() {
        return this.groups.size();
    }
}

