/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.block;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.xbup.core.block.XBBlock;
import org.exbin.xbup.core.block.XBDefaultBlock;
import org.exbin.xbup.core.block.XBEditableDocument;
import org.exbin.xbup.core.type.XBData;

@ParametersAreNonnullByDefault
public class XBDefaultEditableDocument
implements XBEditableDocument {
    @Nonnull
    private XBBlock rootBlock;
    @Nullable
    private BinaryData tailData;

    public XBDefaultEditableDocument(XBBlock rootBlock) {
        this(rootBlock, null);
    }

    public XBDefaultEditableDocument(XBBlock rootBlock, @Nullable BinaryData tailData) {
        this.rootBlock = rootBlock;
        this.tailData = tailData;
    }

    @Override
    @Nonnull
    public Optional<XBBlock> getRootBlock() {
        return Optional.ofNullable(this.rootBlock);
    }

    @Override
    @Nonnull
    public Optional<InputStream> getTailData() {
        return this.tailData == null ? Optional.empty() : Optional.of(this.tailData.getDataInputStream());
    }

    @Override
    public long getTailDataSize() {
        return this.tailData == null ? 0L : this.tailData.getDataSize();
    }

    @Override
    public long getDocumentSize() {
        return -1L;
    }

    @Override
    public void setRootBlock(XBBlock block) {
        this.rootBlock = block;
    }

    @Override
    public void setTailData(@Nullable InputStream source) throws IOException {
        if (source == null) {
            this.tailData = null;
        } else {
            XBData data = new XBData();
            data.loadFromStream(source);
            this.tailData = data;
        }
    }

    @Override
    public void clear() {
        this.rootBlock = new XBDefaultBlock();
        this.tailData = null;
    }
}

