/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.ubnumber.type;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.serial.child.XBTChildInputSerialHandler;
import org.exbin.xbup.core.serial.child.XBTChildOutputSerialHandler;
import org.exbin.xbup.core.serial.child.XBTChildSerializable;
import org.exbin.xbup.core.ubnumber.UBStreamable;
import org.exbin.xbup.core.ubnumber.exception.UBOverFlowException;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

@ParametersAreNonnullByDefault
public class UBPath32
implements UBStreamable,
XBTChildSerializable {
    private long[] path;

    public UBPath32() {
        this.path = new long[0];
    }

    public UBPath32(long[] path) {
        this.path = path;
    }

    public UBPath32(Long[] catalogPath) {
        this.setValue(catalogPath);
    }

    @Override
    public int fromStreamUB(InputStream stream) throws IOException, XBProcessingException {
        UBNat32 arrayLength = new UBNat32();
        int length = arrayLength.fromStreamUB(stream);
        this.path = new long[arrayLength.getInt()];
        for (int i = 0; i < this.path.length; ++i) {
            UBNat32 value = new UBNat32();
            length += value.fromStreamUB(stream);
            this.path[i] = value.getLong();
        }
        return length;
    }

    @Override
    public int toStreamUB(OutputStream stream) throws IOException {
        int length = new UBNat32(this.path.length).toStreamUB(stream);
        for (int i = 0; i < this.path.length; ++i) {
            length += new UBNat32(this.path[i]).toStreamUB(stream);
        }
        return length;
    }

    @Override
    public int getSizeUB() {
        int length = new UBNat32(this.path.length).getSizeUB();
        for (int i = 0; i < this.path.length; ++i) {
            length += new UBNat32(this.path[i]).getSizeUB();
        }
        return length;
    }

    public void setValue(long[] path) throws UBOverFlowException {
        this.path = path;
    }

    private void setValue(Long[] catalogPath) {
        this.path = new long[catalogPath.length];
        for (int i = 0; i < catalogPath.length; ++i) {
            this.path[i] = catalogPath[i];
        }
    }

    public long[] getPath() throws UBOverFlowException {
        return this.path;
    }

    public Long[] getLongPath() throws UBOverFlowException {
        Long[] longPath = new Long[this.path.length];
        for (int i = 0; i < this.path.length; ++i) {
            longPath[i] = this.path[i];
        }
        return longPath;
    }

    @Override
    public void serializeFromXB(XBTChildInputSerialHandler serial) throws XBProcessingException, IOException {
        serial.pullBegin();
        XBAttribute length = serial.pullAttribute();
        this.path = new long[length.getNaturalInt()];
        for (int i = 0; i < this.path.length; ++i) {
            this.path[i] = serial.pullAttribute().getNaturalLong();
        }
        serial.pullEnd();
    }

    @Override
    public void serializeToXB(XBTChildOutputSerialHandler serial) throws XBProcessingException, IOException {
        serial.putBegin(XBBlockTerminationMode.SIZE_SPECIFIED);
        serial.putAttribute(new UBNat32(this.path.length));
        for (int i = 0; i < this.path.length; ++i) {
            serial.putAttribute(new UBNat32(this.path[i]));
        }
        serial.putEnd();
    }
}

