/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.type;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.serial.child.XBTChildInputSerialHandler;
import org.exbin.xbup.core.serial.child.XBTChildOutputSerialHandler;
import org.exbin.xbup.core.serial.child.XBTChildSerializable;
import org.exbin.xbup.core.ubnumber.UBReal;
import org.exbin.xbup.core.ubnumber.type.UBRea;
import org.exbin.xbup.core.util.StreamUtils;

@ParametersAreNonnullByDefault
public class XBTime
implements XBTChildSerializable {
    private UBReal value;
    static long[] XBUP_BLOCKREV_CATALOGPATH = new long[]{0L, 1L, 3L, 1L, 2L, 2L, 0L};
    static long[] XBUP_FORMATREV_CATALOGPATH = new long[]{0L, 1L, 3L, 1L, 2L, 0L, 0L};

    public XBTime() {
        this.value = new UBRea();
    }

    public XBTime(int value) {
        this.value = new UBRea(value);
    }

    public UBReal getValue() {
        return new UBRea(this.value);
    }

    public void setValue(UBReal value) throws XBProcessingException {
        this.value = value;
    }

    public void setValue(int value) throws XBProcessingException {
        this.value.setValue(value);
    }

    @Override
    public void serializeFromXB(XBTChildInputSerialHandler serial) throws XBProcessingException, IOException {
        serial.pullBegin();
        serial.pullChild(new DataBlockSerializator());
        serial.pullEnd();
    }

    @Override
    public void serializeToXB(XBTChildOutputSerialHandler serial) throws XBProcessingException, IOException {
        serial.putBegin(XBBlockTerminationMode.SIZE_SPECIFIED);
        serial.putType(new XBDeclBlockType(XBUP_BLOCKREV_CATALOGPATH));
        serial.putChild(new DataBlockSerializator());
        serial.putEnd();
    }

    @ParametersAreNonnullByDefault
    public class DataBlockSerializator
    implements XBTChildSerializable {
        @Override
        public void serializeFromXB(XBTChildInputSerialHandler serial) throws XBProcessingException, IOException {
            serial.pullBegin();
            InputStream source = serial.pullData();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                StreamUtils.copyInputStreamToOutputStream(source, stream);
            }
            catch (IOException ex) {
                Logger.getLogger(XBTime.class.getName()).log(Level.SEVERE, null, ex);
            }
            byte[] newValue = stream.toByteArray();
            XBTime.this.setValue(newValue[1] >> 8 + newValue[0]);
            serial.pullEnd();
        }

        @Override
        public void serializeToXB(XBTChildOutputSerialHandler serial) throws XBProcessingException, IOException {
            serial.putBegin(XBBlockTerminationMode.SIZE_SPECIFIED);
            byte[] data = new byte[2];
            serial.putData(new ByteArrayInputStream(data));
            serial.putEnd();
        }
    }
}

