/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.type;

import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBSerializationMode;
import org.exbin.xbup.core.type.XBString;

@ParametersAreNonnullByDefault
public class XBCharset
implements XBPSequenceSerializable {
    private Charset charset;
    static final long[] XBUP_BLOCKREV_CATALOGPATH = new long[]{1L, 2L, 3L, 0L};

    public XBCharset() {
        this.charset = Charset.defaultCharset();
    }

    public XBCharset(Charset charset) {
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public void serializeXB(XBPSequenceSerialHandler serial) throws XBProcessingException, IOException {
        serial.begin();
        serial.matchType(new XBDeclBlockType(XBUP_BLOCKREV_CATALOGPATH));
        if (serial.getSerializationMode() == XBSerializationMode.PULL) {
            XBString charsetName = new XBString();
            serial.join(charsetName);
            this.charset = Charset.forName(charsetName.getValue());
        } else {
            XBString charsetName = new XBString(this.charset.name());
            serial.join(charsetName);
        }
        serial.end();
    }
}

