/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.serial.child;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.XBTAttributeToken;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTDataToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTokenType;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;
import org.exbin.xbup.core.serial.XBSerialException;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.XBTReadSerialHandler;
import org.exbin.xbup.core.serial.child.XBChildSerialState;
import org.exbin.xbup.core.serial.child.XBTChildInputSerialHandler;
import org.exbin.xbup.core.serial.child.XBTChildSerializable;
import org.exbin.xbup.core.serial.token.XBTTokenInputSerialHandler;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

@ParametersAreNonnullByDefault
public class XBTChildProviderSerialHandler
implements XBTChildInputSerialHandler,
XBTTokenInputSerialHandler {
    private XBTPullProvider pullProvider;
    private XBChildSerialState state = XBChildSerialState.BLOCK_BEGIN;
    private XBTReadSerialHandler childHandler = null;

    public XBTChildProviderSerialHandler() {
    }

    public XBTChildProviderSerialHandler(XBTReadSerialHandler childHandler) {
        this();
        this.childHandler = childHandler;
    }

    @Override
    public void attachXBTPullProvider(XBTPullProvider pullProvider) {
        this.pullProvider = pullProvider;
    }

    @Override
    @Nonnull
    public XBBlockTerminationMode pullBegin() throws XBProcessingException, IOException {
        if (this.state == XBChildSerialState.EOF) {
            throw new XBSerialException("Unexpected method after block already finished", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        XBTToken token = this.pullProvider.pullXBTToken();
        if (token.getTokenType() != XBTTokenType.BEGIN) {
            throw new XBSerialException("Block must start with block begin", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        this.state = XBChildSerialState.ATTRIBUTE_PART;
        return ((XBTBeginToken)token).getTerminationMode();
    }

    @Override
    @Nonnull
    public XBBlockType pullType() throws XBProcessingException, IOException {
        if (this.state != XBChildSerialState.BLOCK_BEGIN && this.state != XBChildSerialState.ATTRIBUTE_PART) {
            throw new XBSerialException("Block type must be read before attributes", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_BEGIN && this.pullProvider.pullXBTToken().getTokenType() != XBTTokenType.BEGIN) {
            throw new XBSerialException("Block must start with block begin", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        XBTToken token = this.pullProvider.pullXBTToken();
        if (token.getTokenType() != XBTTokenType.TYPE) {
            throw new XBSerialException("Missing block type or reading data block", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        this.state = XBChildSerialState.TYPE;
        return ((XBTTypeToken)token).getBlockType();
    }

    @Override
    @Nonnull
    public XBAttribute pullAttribute() throws XBProcessingException, IOException {
        if (this.state == XBChildSerialState.EOF) {
            throw new XBSerialException("Unexpected method after block already finished", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.DATA) {
            throw new XBSerialException("Unable to get attribute after data", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.CHILDREN) {
            throw new XBSerialException("Unable to get attribute after children", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_BEGIN && this.pullProvider.pullXBTToken().getTokenType() != XBTTokenType.BEGIN) {
            throw new XBSerialException("Block must start with block begin", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        XBTToken token = this.pullProvider.pullXBTToken();
        switch (token.getTokenType()) {
            case BEGIN: {
                this.state = XBChildSerialState.CHILDREN;
                break;
            }
            case ATTRIBUTE: {
                this.state = XBChildSerialState.ATTRIBUTES;
                return ((XBTAttributeToken)token).getAttribute();
            }
            case DATA: {
                if (this.state == XBChildSerialState.ATTRIBUTES) {
                    throw new XBSerialException("Unexpected data after attributes", XBProcessingExceptionType.UNEXPECTED_ORDER);
                }
                throw new XBSerialException("Reading attributes of data block", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
            case END: {
                if (this.state != XBChildSerialState.BLOCK_END) {
                    throw new XBSerialException("Block without data or attributes not allowed", XBProcessingExceptionType.UNEXPECTED_ORDER);
                }
                this.state = XBChildSerialState.EOF;
                break;
            }
            default: {
                throw new XBSerialException("Unexpected token type", XBProcessingExceptionType.UNSUPPORTED);
            }
        }
        this.state = XBChildSerialState.ATTRIBUTES;
        return new UBNat32();
    }

    @Override
    public byte pullByteAttribute() throws XBProcessingException, IOException {
        return (byte)this.pullAttribute().getNaturalInt();
    }

    @Override
    public short pullShortAttribute() throws XBProcessingException, IOException {
        return (short)this.pullAttribute().getNaturalInt();
    }

    @Override
    public int pullIntAttribute() throws XBProcessingException, IOException {
        return this.pullAttribute().getNaturalInt();
    }

    @Override
    public long pullLongAttribute() throws XBProcessingException, IOException {
        return this.pullAttribute().getNaturalLong();
    }

    @Override
    public void pullChild(XBSerializable child) throws XBProcessingException, IOException {
        if (this.state == XBChildSerialState.EOF) {
            throw new XBSerialException("Unexpected method after block already finished", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_END) {
            throw new XBSerialException("No more children available", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.DATA) {
            throw new XBSerialException("No children after data allowed", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_BEGIN && this.pullProvider.pullXBTToken().getTokenType() != XBTTokenType.BEGIN) {
            throw new XBSerialException("Block must start with block begin", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (child instanceof XBTChildSerializable) {
            this.state = XBChildSerialState.CHILDREN;
            XBTChildProviderSerialHandler childInput = new XBTChildProviderSerialHandler();
            childInput.attachXBTPullProvider(this.pullProvider);
            ((XBTChildSerializable)child).serializeFromXB(childInput);
        } else if (this.childHandler != null) {
            this.childHandler.read(child);
        } else {
            throw new XBProcessingException("Unsupported child serialization", XBProcessingExceptionType.UNKNOWN);
        }
    }

    @Override
    public void pullAppend(XBSerializable child) throws XBProcessingException, IOException {
        if (child instanceof XBTChildSerializable) {
            ((XBTChildSerializable)child).serializeFromXB(this);
        } else if (this.childHandler != null) {
            this.childHandler.read(child);
        } else {
            throw new XBProcessingException("Unsupported child serialization", XBProcessingExceptionType.UNKNOWN);
        }
    }

    @Override
    @Nonnull
    public InputStream pullData() throws XBProcessingException, IOException {
        if (this.state == XBChildSerialState.EOF) {
            throw new XBSerialException("Unexpected method after block already finished", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.ATTRIBUTES) {
            throw new XBSerialException("No data block allowed after attributes", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.DATA) {
            throw new XBSerialException("No data block allowed after data", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_BEGIN && this.pullProvider.pullXBTToken().getTokenType() != XBTTokenType.BEGIN) {
            throw new XBSerialException("Block must start with block begin", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        XBTToken token = this.pullProvider.pullXBTToken();
        if (token.getTokenType() != XBTTokenType.DATA) {
            throw new XBSerialException("Data block missing", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        this.state = XBChildSerialState.DATA;
        return ((XBTDataToken)token).getData();
    }

    @Override
    public void pullEnd() throws XBProcessingException, IOException {
        if (this.state == XBChildSerialState.EOF) {
            throw new XBSerialException("Unexpected method after block already finished", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        XBTToken token = this.pullProvider.pullXBTToken();
        if (token.getTokenType() != XBTTokenType.END) {
            throw new XBSerialException("End token was expected but not received", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        this.state = XBChildSerialState.EOF;
    }
}

