/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token.event.convert;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBasicBlockType;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.XBTAttributeToken;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTDataToken;
import org.exbin.xbup.core.parser.token.XBTEndToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.parser.token.event.XBTEventFilter;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

@ParametersAreNonnullByDefault
public class XBTCompactingEventFilter
implements XBTEventFilter {
    @Nonnull
    private XBTEventListener eventListener;
    private boolean unknownMode = false;
    private boolean emptyDataMode = true;
    private int zeroAttributes = 0;
    private final List<XBBlockTerminationMode> emptyNodes = new ArrayList<XBBlockTerminationMode>();
    @Nullable
    private XBBlockTerminationMode blockMode = null;

    public XBTCompactingEventFilter(XBTEventListener eventListener) {
        this.eventListener = eventListener;
    }

    @Override
    public void attachXBTEventListener(XBTEventListener eventListener) {
        this.eventListener = eventListener;
    }

    @Override
    public void putXBTToken(XBTToken token) throws XBProcessingException, IOException {
        switch (token.getTokenType()) {
            case BEGIN: {
                this.blockMode = ((XBTBeginToken)token).getTerminationMode();
                this.emptyDataMode = true;
                this.zeroAttributes = 0;
                break;
            }
            case TYPE: {
                this.flushEmptyNodes();
                if (this.emptyDataMode) {
                    this.eventListener.putXBTToken(XBTBeginToken.create(this.blockMode));
                    this.emptyDataMode = false;
                }
                this.unknownMode = ((XBTTypeToken)token).getBlockType().getAsBasicType() == XBBasicBlockType.UNKNOWN_BLOCK;
                this.eventListener.putXBTToken(token);
                break;
            }
            case ATTRIBUTE: {
                this.flushEmptyNodes();
                if (this.emptyDataMode) {
                    this.eventListener.putXBTToken(XBTBeginToken.create(this.blockMode));
                    this.emptyDataMode = false;
                }
                if (!this.unknownMode) {
                    if (((XBTAttributeToken)token).getAttribute().isNaturalZero()) {
                        ++this.zeroAttributes;
                        break;
                    }
                    this.flushAttributes();
                }
                this.eventListener.putXBTToken(token);
                break;
            }
            case DATA: {
                if (((XBTDataToken)token).isEmpty()) {
                    this.emptyNodes.add(this.blockMode);
                    break;
                }
                this.emptyDataMode = false;
                this.flushEmptyNodes();
                this.eventListener.putXBTToken(XBTBeginToken.create(this.blockMode));
                this.eventListener.putXBTToken(token);
                break;
            }
            case END: {
                if (!this.emptyDataMode) {
                    this.eventListener.putXBTToken(token);
                    this.emptyNodes.clear();
                    break;
                }
                this.emptyDataMode = false;
            }
        }
    }

    private void flushAttributes() throws IOException, XBProcessingException {
        for (int i = 0; i < this.zeroAttributes; ++i) {
            this.eventListener.putXBTToken(XBTAttributeToken.create(new UBNat32(0)));
        }
        this.zeroAttributes = 0;
    }

    private void flushEmptyNodes() {
        try {
            for (XBBlockTerminationMode nodeMode : this.emptyNodes) {
                this.eventListener.putXBTToken(XBTBeginToken.create(nodeMode));
                this.eventListener.putXBTToken(XBTDataToken.create(new ByteArrayInputStream(new byte[0])));
                this.eventListener.putXBTToken(XBTEndToken.create());
            }
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBTCompactingEventFilter.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.emptyNodes.clear();
    }
}

