/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token.event;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.parser.XBParserMode;
import org.exbin.xbup.core.parser.XBParsingException;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBHead;
import org.exbin.xbup.core.parser.basic.wrapper.FixedDataInputStreamWrapper;
import org.exbin.xbup.core.parser.basic.wrapper.TailDataInputStreamWrapper;
import org.exbin.xbup.core.parser.basic.wrapper.TerminatedDataInputStreamWrapper;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBEndToken;
import org.exbin.xbup.core.parser.token.event.XBEventListener;
import org.exbin.xbup.core.parser.token.event.XBEventProducer;
import org.exbin.xbup.core.ubnumber.type.UBENat32;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

@ParametersAreNonnullByDefault
public class XBEventReader
implements XBEventProducer {
    private XBParserMode parserMode = XBParserMode.FULL;
    private InputStream source;
    private XBEventListener listener;

    public XBEventReader() {
    }

    public XBEventReader(InputStream inputStream) throws IOException {
        this();
        this.openStream(inputStream);
    }

    public XBEventReader(InputStream inputStream, XBParserMode parserMode) throws IOException {
        this();
        this.parserMode = parserMode;
        this.openStream(inputStream);
    }

    private void openStream(InputStream stream) throws IOException {
        this.source = stream;
    }

    public void open(InputStream stream) throws IOException {
        this.openStream(stream);
    }

    public void read() throws XBProcessingException, IOException {
        if (this.parserMode != XBParserMode.SINGLE_BLOCK && this.parserMode != XBParserMode.SKIP_HEAD) {
            XBHead.checkXBUPHead(this.source);
        }
        this.readNode();
    }

    private void readNode() throws XBProcessingException, IOException {
        ArrayList<Integer> sizeLimits = new ArrayList<Integer>();
        do {
            UBNat32 attributePartSize = new UBNat32();
            int attributePartSizeLength = attributePartSize.fromStreamUB(this.source);
            XBEventReader.shrinkStatus(sizeLimits, attributePartSizeLength);
            if (attributePartSize.getLong() == 0L) {
                if (sizeLimits.isEmpty() || sizeLimits.get(sizeLimits.size() - 1) != null) {
                    throw new XBParsingException("Unexpected terminator", XBProcessingExceptionType.UNEXPECTED_TERMINATOR);
                }
                sizeLimits.remove(sizeLimits.size() - 1);
                if (sizeLimits.isEmpty() && this.parserMode != XBParserMode.SINGLE_BLOCK && this.parserMode != XBParserMode.SKIP_TAIL && this.source.available() > 0) {
                    this.listener.putXBToken(XBDataToken.create(new TailDataInputStreamWrapper(this.source)));
                }
                this.listener.putXBToken(XBEndToken.create());
            } else {
                int attributePartSizeValue = attributePartSize.getInt();
                XBEventReader.shrinkStatus(sizeLimits, attributePartSizeValue);
                UBENat32 dataPartSize = new UBENat32();
                int dataPartSizeLength = dataPartSize.fromStreamUB(this.source);
                Integer dataPartSizeValue = dataPartSize.isInfinity() ? null : Integer.valueOf(dataPartSize.getInt());
                this.listener.putXBToken(XBBeginToken.create(dataPartSizeValue == null ? XBBlockTerminationMode.TERMINATED_BY_ZERO : XBBlockTerminationMode.SIZE_SPECIFIED));
                if (attributePartSizeValue == dataPartSizeLength) {
                    InputStream dataWrapper = dataPartSizeValue == null ? new TerminatedDataInputStreamWrapper(this.source) : new FixedDataInputStreamWrapper(this.source, dataPartSizeValue);
                    this.listener.putXBToken(XBDataToken.create(dataWrapper));
                    dataWrapper.finish();
                    XBEventReader.shrinkStatus(sizeLimits, (int)dataWrapper.getLength());
                    if (sizeLimits.isEmpty() && this.parserMode != XBParserMode.SINGLE_BLOCK && this.parserMode != XBParserMode.SKIP_TAIL && this.source.available() > 0) {
                        this.listener.putXBToken(XBDataToken.create(new TailDataInputStreamWrapper(this.source)));
                    }
                    this.listener.putXBToken(XBEndToken.create());
                } else {
                    sizeLimits.add(dataPartSizeValue);
                    attributePartSizeValue -= dataPartSizeLength;
                    while (attributePartSizeValue > 0) {
                        UBNat32 attribute = new UBNat32();
                        int attributeLength = attribute.fromStreamUB(this.source);
                        if (attributeLength > attributePartSizeValue) {
                            throw new XBParsingException("Attribute overflow", XBProcessingExceptionType.ATTRIBUTE_OVERFLOW);
                        }
                        attributePartSizeValue -= attributeLength;
                        this.listener.putXBToken(XBAttributeToken.create(attribute));
                    }
                }
            }
            while (sizeLimits.size() > 0 && sizeLimits.get(sizeLimits.size() - 1) != null && (Integer)sizeLimits.get(sizeLimits.size() - 1) == 0) {
                sizeLimits.remove(sizeLimits.size() - 1);
                if (sizeLimits.isEmpty() && this.parserMode != XBParserMode.SINGLE_BLOCK && this.parserMode != XBParserMode.SKIP_TAIL && this.source.available() > 0) {
                    TailDataInputStreamWrapper dataWrapper = new TailDataInputStreamWrapper(this.source);
                    this.listener.putXBToken(XBDataToken.create(dataWrapper));
                }
                this.listener.putXBToken(XBEndToken.create());
            }
        } while (!sizeLimits.isEmpty());
    }

    public void close() throws IOException {
        this.source.close();
    }

    private static void shrinkStatus(List<Integer> sizeLimits, int length) throws XBParsingException {
        for (int depthLevel = 0; depthLevel < sizeLimits.size(); ++depthLevel) {
            Integer limit = sizeLimits.get(depthLevel);
            if (limit == null) continue;
            if (limit < length) {
                throw new XBParsingException("Block overflow", XBProcessingExceptionType.BLOCK_OVERFLOW);
            }
            sizeLimits.set(depthLevel, limit - length);
        }
    }

    @Override
    public void attachXBEventListener(XBEventListener eventListener) {
        this.listener = eventListener;
    }

    @Nonnull
    public String toString() {
        String retValue = super.toString();
        return retValue;
    }
}

